/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TruncateTableAndOnlineBackupTest
extends BaseJDBCTestCase {
    static String home = null;
    static final String dbName = "TTOB_db";
    static final String backupDir = "TTOB_backup";

    public TruncateTableAndOnlineBackupTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("TruncateTableAndOnlineBackupTest");
        baseTestSuite.addTest(TruncateTableAndOnlineBackupTest.baseSuite("TruncateTableAndOnlineBackupTest:Embedded"));
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite, dbName);
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(TruncateTableAndOnlineBackupTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    public void setUp() throws Exception {
        this.getConnection();
        home = TruncateTableAndOnlineBackupTest.getSystemProperty("derby.system.home");
        Statement statement = this.createStatement();
        statement.executeUpdate("create table truncable(i int)");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("insert into truncable values (?)");
        this.getConnection().setAutoCommit(false);
        for (int i = 1; i <= 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.getConnection().commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.getConnection().createStatement().execute("drop table truncable");
        super.tearDown();
    }

    public void testUncommittedTruncateBasicBackup() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        statement.executeUpdate("truncate table truncable");
        ResultSet resultSet = statement.executeQuery("select * from truncable");
        JDBC.assertEmpty(resultSet);
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        String string = home + "/TTOB_backup";
        callableStatement.setString(1, string);
        callableStatement.execute();
        DataSource dataSource = JDBCDataSource.getDataSource(string + "/TTOB_db");
        Connection connection = dataSource.getConnection();
        Statement statement2 = connection.createStatement();
        JDBC.assertFullResultSet(statement2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        connection.close();
        DataSource[] dataSourceArray = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(string + "/TTOB_db")};
        for (int i = 0; i < dataSourceArray.length; ++i) {
            JDBCDataSource.setBeanProperty(dataSourceArray[i], "connectionAttributes", "shutdown=true");
            try {
                dataSourceArray[i].getConnection();
                TruncateTableAndOnlineBackupTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException sQLException) {
                TruncateTableAndOnlineBackupTest.assertSQLState("database shutdown", "08006", sQLException);
            }
        }
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(string));
    }

    public void testUncommittedTruncateBackupEnableLog() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        statement.executeUpdate("truncate table truncable");
        ResultSet resultSet = statement.executeQuery("select * from truncable");
        JDBC.assertEmpty(resultSet);
        CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(?,1)");
        String string = home + "/TTOB_backup";
        callableStatement.setString(1, string);
        callableStatement.execute();
        this.commit();
        DataSource dataSource = JDBCDataSource.getDataSource(string + "/TTOB_db");
        Connection connection = dataSource.getConnection();
        Statement statement2 = connection.createStatement();
        JDBC.assertFullResultSet(statement2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        connection.close();
        String string2 = string + "2";
        callableStatement.setString(1, string2);
        callableStatement.execute();
        DataSource dataSource2 = JDBCDataSource.getDataSource(string2 + "/TTOB_db");
        Connection connection2 = dataSource2.getConnection();
        Statement statement3 = connection2.createStatement();
        resultSet = statement3.executeQuery("select * from truncable");
        JDBC.assertEmpty(resultSet);
        DataSource[] dataSourceArray = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(string + "/TTOB_db"), JDBCDataSource.getDataSource(string2 + "/TTOB_db")};
        for (int i = 0; i < dataSourceArray.length; ++i) {
            JDBCDataSource.setBeanProperty(dataSourceArray[i], "connectionAttributes", "shutdown=true");
            try {
                dataSourceArray[i].getConnection();
                TruncateTableAndOnlineBackupTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException sQLException) {
                TruncateTableAndOnlineBackupTest.assertSQLState("database shutdown", "08006", sQLException);
            }
        }
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(string));
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(string2));
    }

    public void testTruncateFreezeUnfreeze() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        statement.executeUpdate("truncate table truncable");
        ResultSet resultSet = statement.executeQuery("select * from truncable");
        JDBC.assertEmpty(resultSet);
        statement.execute("call syscs_util.syscs_freeze_database()");
        String string = "TTOB_backup2";
        File file = new File(home, dbName);
        File file2 = new File(home, string);
        PrivilegedFileOpsForTests.copy(file, file2);
        resultSet = statement.executeQuery("select * from truncable");
        JDBC.assertEmpty(resultSet);
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        Connection connection = dataSource.getConnection();
        Statement statement2 = connection.createStatement();
        JDBC.assertFullResultSet(statement2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        statement.execute("call syscs_util.syscs_unfreeze_database()");
        resultSet = statement.executeQuery("select * from truncable");
        JDBC.assertEmpty(resultSet);
        statement.executeUpdate("insert into truncable values(2001)");
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from truncable"), new String[][]{{"1"}});
        this.rollback();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        JDBC.assertFullResultSet(statement2.executeQuery("select count(*) from truncable"), new String[][]{{"1000"}});
        statement2.close();
        connection.close();
        DataSource[] dataSourceArray = new DataSource[]{JDBCDataSource.getDataSource(), dataSource};
        for (int i = 0; i < dataSourceArray.length; ++i) {
            JDBCDataSource.setBeanProperty(dataSourceArray[i], "connectionAttributes", "shutdown=true");
            try {
                dataSourceArray[i].getConnection();
                TruncateTableAndOnlineBackupTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException sQLException) {
                TruncateTableAndOnlineBackupTest.assertSQLState("database shutdown", "08006", sQLException);
            }
        }
        TruncateTableAndOnlineBackupTest.assertDirectoryDeleted(new File(home + "/" + string));
    }
}

