/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobRsGetterTest
extends BaseJDBCTestCase {
    private static final String TABLE = "LOB_RS_GETTER_TEST";
    private static final boolean UNSUPPORTED = false;
    private static final boolean SUPPORTED = true;
    private static final int BLOB = 0;
    private static final int CLOB = 1;
    private static final int GET_BYTES = 0;
    private static final int GET_STRING = 1;
    private static final int GET_ASCII_STREAM = 2;
    private static final int GET_BINARY_STREAM = 3;
    private static final int GET_CHARACTER_STREAM = 4;
    private static final int GET_CLOB = 5;
    private static final int GET_BLOB = 6;
    private static final int GET_OBJECT = 7;
    private static final boolean X = true;
    private static final boolean E = true;
    private static final boolean u = false;
    private static final boolean[][] COMPATIBLE_GETTERS = new boolean[][]{{true, false}, {true, true}, {true, true}, {true, false}, {true, true}, {false, true}, {true, false}, {true, true}};
    private static final String[] GETTER_NAMES = new String[]{"getBytes", "getString", "getAsciiStream", "getBinaryStream", "getCharacterStream", "getClob", "getBlob", "getObject"};

    public LobRsGetterTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(LobRsGetterTest.class, false);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = statement.getConnection();
                BaseJDBCTestCase.dropTable(connection, LobRsGetterTest.TABLE);
                statement.executeUpdate("create table LOB_RS_GETTER_TEST(id INT GENERATED ALWAYS AS IDENTITY, dBlob BLOB, dClob CLOB)");
                PreparedStatement preparedStatement = connection.prepareStatement("insert into LOB_RS_GETTER_TEST(dBlob, dClob) values (?,?)");
                int n = 177152;
                int n2 = 300;
                preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n), n);
                preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
                preparedStatement.executeUpdate();
                preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n2), n2);
                preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n2), n2);
                preparedStatement.executeUpdate();
                preparedStatement.setNull(1, 2004);
                preparedStatement.setNull(2, 2005);
                preparedStatement.executeUpdate();
                JDBC.assertDrainResults(statement.executeQuery("select * from LOB_RS_GETTER_TEST"), 3);
                preparedStatement.close();
                statement.close();
            }
        };
    }

    public void testBlobGettersSimple() throws SQLException {
        this._testGettersSimple("dBlob", 0);
    }

    public void testClobGettersSimple() throws SQLException {
        this._testGettersSimple("dClob", 1);
    }

    public void testBlobGettersSimpleNegative() throws SQLException {
        this._testGettersSimpleNegative("dBlob", 0);
    }

    public void testClobGettersSimpleNegative() throws SQLException {
        this._testGettersSimpleNegative("dClob", 1);
    }

    public void testBlobGettersMultiInvocation() throws SQLException {
        this._testGettersMultiInvocation("dBlob", 0);
    }

    public void testClobGettersMultiInvocation() throws SQLException {
        this._testGettersMultiInvocation("dClob", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlobGetXFollowedByGetBytes() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dBlob from LOB_RS_GETTER_TEST");
        for (int i = 0; i < COMPATIBLE_GETTERS.length; ++i) {
            if (!COMPATIBLE_GETTERS[i][0]) continue;
            ResultSet resultSet = preparedStatement.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet.next());
            this.invokeGetter(resultSet, 0, i);
            try {
                this.invokeGetter(resultSet, 0, 0);
                LobRsGetterTest.assertTrue((String)("getBytes should have failed after: " + this.debugInfo(1, resultSet, 0, i)), (i == 0 || i == 1 ? 1 : 0) != 0);
                continue;
            }
            catch (SQLException sQLException) {
                LobRsGetterTest.assertTrue((i != 0 ? 1 : 0) != 0);
                LobRsGetterTest.assertSQLState(this.debugInfo(1, resultSet, 0, i) + " followed by getBytes", "XCL18", sQLException);
                continue;
            }
            finally {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClobGetXFollowedByGetString() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select dClob from LOB_RS_GETTER_TEST");
        for (int i = 0; i < COMPATIBLE_GETTERS.length; ++i) {
            if (!COMPATIBLE_GETTERS[i][1]) continue;
            ResultSet resultSet = preparedStatement.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet.next());
            this.invokeGetter(resultSet, 1, i);
            try {
                this.invokeGetter(resultSet, 1, 1);
                LobRsGetterTest.assertTrue((String)("getString should have failed after: " + this.debugInfo(1, resultSet, 1, i)), (i == 1 ? 1 : 0) != 0);
                continue;
            }
            catch (SQLException sQLException) {
                LobRsGetterTest.assertTrue((i != 1 ? 1 : 0) != 0);
                LobRsGetterTest.assertSQLState(this.debugInfo(1, resultSet, 1, i) + " followed by getString", "XCL18", sQLException);
                continue;
            }
            finally {
                resultSet.close();
            }
        }
    }

    public void testCorrectBlobDataWithMultiCall() throws IOException, SQLException {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("select id from LOB_RS_GETTER_TEST");
        String string = "select dBlob from LOB_RS_GETTER_TEST where id = ?";
        PreparedStatement preparedStatement2 = this.prepareStatement(string);
        PreparedStatement preparedStatement3 = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            preparedStatement2.setInt(1, resultSet.getInt(1));
            preparedStatement3.setInt(1, resultSet.getInt(1));
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getBytes(1);
            resultSet2.getString(1);
            ResultSet resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getBinaryStream(1), resultSet2.getBinaryStream(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            resultSet2.getBytes(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getBlob(1), resultSet2.getBlob(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getBytes(1);
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getCharacterStream(1), resultSet2.getCharacterStream(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getBytes(1);
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertTrue((boolean)Arrays.equals(resultSet3.getBytes(1), resultSet2.getBytes(1)));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getBytes(1);
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals((String)resultSet3.getString(1), (String)resultSet2.getString(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            resultSet2.getBytes(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            Blob blob = (Blob)resultSet2.getObject(1);
            Blob blob2 = (Blob)resultSet3.getObject(1);
            LobRsGetterTest.assertEquals(blob2, blob);
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getBytes(1);
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getAsciiStream(1), resultSet2.getAsciiStream(1));
            resultSet2.close();
            resultSet3.close();
        }
        this.rollback();
    }

    public void testCorrectClobDataWithMultiCall() throws IOException, SQLException {
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("select id, dClob from LOB_RS_GETTER_TEST");
        String string = "select dClob from LOB_RS_GETTER_TEST where id = ?";
        PreparedStatement preparedStatement2 = this.prepareStatement(string);
        PreparedStatement preparedStatement3 = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            preparedStatement2.setInt(1, resultSet.getInt(1));
            preparedStatement3.setInt(1, resultSet.getInt(1));
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            ResultSet resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals((String)resultSet3.getString(1), (String)resultSet2.getString(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getCharacterStream(1), resultSet2.getCharacterStream(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getClob(1), resultSet2.getClob(1));
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            Clob clob = (Clob)resultSet2.getObject(1);
            Clob clob2 = (Clob)resultSet3.getObject(1);
            LobRsGetterTest.assertEquals(clob2, clob);
            resultSet2.close();
            resultSet3.close();
            resultSet2 = preparedStatement2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet2.next());
            resultSet2.getString(1);
            resultSet3 = preparedStatement3.executeQuery();
            LobRsGetterTest.assertTrue((boolean)resultSet3.next());
            LobRsGetterTest.assertEquals(resultSet3.getAsciiStream(1), resultSet2.getAsciiStream(1));
            resultSet2.close();
            resultSet3.close();
        }
        this.rollback();
    }

    private void _testGettersMultiInvocation(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select " + string + " from LOB_RS_GETTER_TEST");
        for (int i = 0; i < COMPATIBLE_GETTERS.length; ++i) {
            boolean bl = COMPATIBLE_GETTERS[i][n];
            if (!bl) continue;
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            this.invokeGetter(resultSet, n, i);
            try {
                this.invokeGetter(resultSet, n, i);
                if (i == 0 || i == 1) continue;
                LobRsGetterTest.fail((String)("calling the getter twice should have failed: " + GETTER_NAMES[i] + " on " + this.typeName(n)));
                continue;
            }
            catch (SQLException sQLException) {
                LobRsGetterTest.assertSQLState("XCL18", sQLException);
            }
        }
    }

    private void _testGettersSimpleNegative(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select " + string + " from LOB_RS_GETTER_TEST");
        for (int i = 0; i < COMPATIBLE_GETTERS.length; ++i) {
            boolean bl = COMPATIBLE_GETTERS[i][n];
            if (bl) continue;
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    this.invokeGetter(resultSet, n, i);
                    if (resultSet.wasNull()) continue;
                    LobRsGetterTest.fail((String)("expected getter to fail on non-NULL value: " + this.debugInfo(1, resultSet, n, i)));
                }
                catch (SQLException sQLException) {
                    LobRsGetterTest.assertSQLState("22005", sQLException);
                }
            }
            resultSet.close();
        }
    }

    private void _testGettersSimple(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select " + string + " from LOB_RS_GETTER_TEST");
        for (int i = 0; i < COMPATIBLE_GETTERS.length; ++i) {
            boolean bl = COMPATIBLE_GETTERS[i][n];
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    this.invokeGetter(resultSet, n, i);
                    if (bl) continue;
                    LobRsGetterTest.assertTrue((String)("should not have worked: " + this.debugInfo(1, resultSet, n, i)), (boolean)resultSet.wasNull());
                }
                catch (SQLException sQLException) {
                    if (!bl) {
                        LobRsGetterTest.assertSQLState("22005", sQLException);
                        continue;
                    }
                    throw sQLException;
                }
            }
            resultSet.close();
        }
        preparedStatement.close();
    }

    private void invokeGetter(ResultSet resultSet, int n, int n2) throws SQLException {
        this.invokeGetter(1, resultSet, n, n2);
    }

    private void invokeGetter(int n, ResultSet resultSet, int n2, int n3) throws SQLException {
        LobRsGetterTest.println("invoking " + this.debugInfo(n, resultSet, n2, n3));
        Object object = switch (n3) {
            case 0 -> resultSet.getBytes(n);
            case 1 -> (Object)resultSet.getString(n);
            case 2 -> (Object)resultSet.getAsciiStream(n);
            case 3 -> (Object)resultSet.getBinaryStream(n);
            case 4 -> (Object)resultSet.getCharacterStream(n);
            case 5 -> (Object)resultSet.getClob(n);
            case 6 -> (Object)resultSet.getBlob(n);
            case 7 -> (Object)resultSet.getObject(n);
            default -> {
                LobRsGetterTest.fail((String)("unsupported getter index: " + n3));
                throw new IllegalStateException();
            }
        };
        if (resultSet.wasNull()) {
            LobRsGetterTest.assertNull((Object)object);
        } else {
            LobRsGetterTest.assertNotNull((Object)object);
        }
    }

    private String typeName(int n) {
        switch (n) {
            case 0: {
                return "BLOB";
            }
            case 1: {
                return "CLOB";
            }
        }
        return "UNKNOWN";
    }

    private String debugInfo(int n, ResultSet resultSet, int n2, int n3) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        return GETTER_NAMES[n3] + " on " + this.typeName(n2) + " (meta:col=" + n + ",type=" + resultSetMetaData.getColumnTypeName(n) + ",name=" + resultSetMetaData.getColumnName(n) + ")";
    }
}

