/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BLOBDataModelSetup;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.functionTests.util.streams.ReadOnceByteArrayInputStream;
import org.apache.derbyTesting.functionTests.util.streams.StringReaderWithLength;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public final class BLOBTest
extends BaseJDBCTestCase {
    public BLOBTest(String string) {
        super(string);
    }

    public void testUpdateBlobFromScrollableResultSetUsingResultSetMethods() throws SQLException, IOException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        resultSet.last();
        int n = resultSet.getInt(1) + 11;
        int n2 = resultSet.getInt(2) / 2;
        this.testUpdateBlobWithResultSetMethods(resultSet, n, n2);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(n, n2, resultSet.getBlob(3));
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetUsingResultSetMethods() throws SQLException, IOException {
        int n;
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        while (resultSet.next()) {
            BLOBTest.println("Next");
            n = resultSet.getInt(1);
            if (n != 11) continue;
            break;
        }
        n = resultSet.getInt(1) + 11;
        int n2 = resultSet.getInt(2) / 2;
        this.testUpdateBlobWithResultSetMethods(resultSet, n, n2);
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromScrollableResultSetUsingPositionedUpdates() throws SQLException, IOException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        resultSet.last();
        int n = resultSet.getInt(1) + 11;
        int n2 = resultSet.getInt(2) / 2;
        this.testUpdateBlobWithPositionedUpdate(resultSet, n, n2);
        resultSet.relative(0);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(n, n2, resultSet.getBlob(3));
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetUsingPositionedUpdates() throws SQLException, IOException {
        int n;
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        while (resultSet.next()) {
            BLOBTest.println("Next");
            n = resultSet.getInt(1);
            if (n != 11) continue;
            break;
        }
        n = resultSet.getInt(1) + 11;
        int n2 = resultSet.getInt(2) / 2;
        this.testUpdateBlobWithPositionedUpdate(resultSet, n, n2);
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromScrollableResultSetWithProjectUsingResultSetMethods() throws SQLException, IOException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT data,val,length from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        resultSet.last();
        int n = resultSet.getInt(2) + 11;
        int n2 = resultSet.getInt(3) / 2;
        this.testUpdateBlobWithResultSetMethods(resultSet, n, n2);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(n, n2, resultSet.getBlob(1));
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetWithProjectUsingResultSetMethods() throws SQLException, IOException {
        int n;
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT data,val,length from " + BLOBDataModelSetup.getBlobTableName());
        while (resultSet.next()) {
            BLOBTest.println("Next");
            n = resultSet.getInt("VAL");
            if (n != 11) continue;
            break;
        }
        n = resultSet.getInt("VAL") + 11;
        this.testUpdateBlobWithResultSetMethods(resultSet, n, 0x2000000);
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromScrollableResultSetWithProjectUsingPositionedUpdates() throws SQLException, IOException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT data from " + BLOBDataModelSetup.getBlobTableName() + " WHERE val= 11");
        BLOBTest.println("Last");
        resultSet.last();
        this.testUpdateBlobWithPositionedUpdate(resultSet, 22, 0x2000000);
        resultSet.relative(0);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(22, 0x2000000, resultSet.getBlob("DATA"));
        resultSet.close();
        statement.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetWithProjectUsingPositionedUpdates() throws SQLException, IOException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("SELECT data from " + BLOBDataModelSetup.getBlobTableName() + " WHERE val = 11");
        resultSet.next();
        this.testUpdateBlobWithPositionedUpdate(resultSet, 22, 0x2000000);
        resultSet.close();
        statement.close();
    }

    private void testUpdateBlobWithResultSetMethods(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        int n3 = resultSet.getInt("VAL");
        int n4 = resultSet.getInt("LENGTH");
        BLOBTest.println("VerifyBlob");
        this.verifyBlob(n3, n4, resultSet.getBlob("DATA"));
        BLOBTest.println("UpdateBlob");
        TestInputStream testInputStream = new TestInputStream(n2, n);
        resultSet.updateInt("VAL", n);
        resultSet.updateInt("LENGTH", n2);
        resultSet.updateBinaryStream("DATA", (InputStream)testInputStream, n2);
        resultSet.updateRow();
        BLOBTest.println("Verify updated blob with another query");
        this.verifyNewValueInTable(n, n2);
    }

    private void testUpdateBlobWithPositionedUpdate(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE " + BLOBDataModelSetup.getBlobTableName() + " SET val=?, length = ?, data = ? WHERE CURRENT OF " + resultSet.getCursorName());
        BLOBTest.println("UpdateBlob");
        TestInputStream testInputStream = new TestInputStream(n2, n);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.setBinaryStream(3, (InputStream)testInputStream, n2);
        preparedStatement.executeUpdate();
        BLOBTest.println("Verify updated blob with another query");
        this.verifyNewValueInTable(n, n2);
    }

    public void testBlobCastInValuesClause() throws IOException, SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("values cast(? as blob)");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(38912L), 38912);
        ResultSet resultSet = preparedStatement.executeQuery();
        BLOBTest.assertTrue((boolean)resultSet.next());
        Blob blob = resultSet.getBlob(1);
        BLOBTest.assertEquals((long)38912L, (long)blob.length());
        BLOBTest.assertEquals((int)100, (int)blob.getBytes(32741L, 100).length);
        BLOBTest.assertEquals((int)1029, (int)blob.getBytes(19456L, 1029).length);
        BLOBTest.assertEquals(new LoopingAlphabetStream(38912L), blob.getBinaryStream());
        BLOBTest.assertEquals((long)-1L, (long)blob.position(new byte[]{97, 65}, 1L));
        BLOBTest.assertEquals((long)38912L, (long)blob.length());
        BLOBTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testDerby4477_3645_3646_Repro() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V BLOB(590473235) )");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T_MAIN(V) VALUES (?)");
        byte[] byArray = new byte[35000];
        for (int i = 0; i < 35000; ++i) {
            byArray[i] = (byte)i;
        }
        preparedStatement.setBytes(1, byArray);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE T_COPY ( V1 BLOB(2M), V2 BLOB(2M))");
        statement.executeUpdate("INSERT INTO T_COPY SELECT  V, V FROM T_MAIN");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T_COPY");
        resultSet.next();
        String string = resultSet.getString(1);
        String string2 = resultSet.getString(2);
        BLOBTest.assertEquals((int)string.length(), (int)string2.length());
        for (int i = 0; i < string.length(); ++i) {
            BLOBTest.assertEquals((char)string.charAt(i), (char)string2.charAt(i));
        }
        resultSet = statement.executeQuery("SELECT V from T_MAIN");
        resultSet.next();
        String string3 = resultSet.getString(1);
        BLOBTest.assertEquals((int)string.length(), (int)string3.length());
        for (int i = 0; i < string.length(); ++i) {
            BLOBTest.assertEquals((char)string.charAt(i), (char)string3.charAt(i));
        }
        resultSet = statement.executeQuery("SELECT 'I', V, ID, V from T_MAIN");
        resultSet.next();
        InputStream inputStream = resultSet.getBinaryStream(2);
        for (int i = 0; i < 35000; ++i) {
            BLOBTest.assertEquals((byte)((byte)i), (byte)((byte)inputStream.read()));
        }
        BLOBTest.assertEquals((int)-1, (int)inputStream.read());
        inputStream.close();
        InputStream inputStream2 = resultSet.getBinaryStream(4);
        for (int i = 0; i < 35000; ++i) {
            BLOBTest.assertEquals((byte)((byte)i), (byte)((byte)inputStream2.read()));
        }
        BLOBTest.assertEquals((int)-1, (int)inputStream2.read());
        inputStream2.close();
        resultSet.close();
        this.rollback();
    }

    public void testDerby4477_2349_Repro() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V BLOB(590473235) )");
        statement.executeUpdate("CREATE TABLE T_ACTION_ROW(ID INT, A CHAR(1), V1 BLOB(590473235), V2 BLOB(590473235) )");
        statement.executeUpdate("CREATE TABLE T_ACTION_STATEMENT(ID INT, A CHAR(1), V1 BLOB(590473235), V2 BLOB(590473235) )");
        statement.executeUpdate("CREATE TRIGGER AIR AFTER INSERT ON T_MAIN     REFERENCING NEW AS N FOR EACH ROW     INSERT INTO T_ACTION_ROW(A, V1, ID, V2)         VALUES ('I', N.V, N.ID, N.V)");
        statement.executeUpdate("CREATE TRIGGER AIS AFTER INSERT ON T_MAIN     REFERENCING NEW_TABLE AS N FOR EACH STATEMENT     INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2)         SELECT 'I', V, ID, V FROM N");
        statement.executeUpdate("INSERT INTO T_MAIN(V) VALUES NULL");
        statement.close();
        this.actionTypesCompareMainToAction(1);
        int n = 2004;
        int n2 = 590473235;
        Random random = new Random();
        String string = "INSERT INTO T_MAIN(V) VALUES (?)";
        String string2 = "INSERT INTO T_MAIN(V) VALUES (?), (?), (?)";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        BLOBTest.setRandomValue(random, preparedStatement, 1, n, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.actionTypesCompareMainToAction(2);
        preparedStatement = this.prepareStatement(string2);
        BLOBTest.setRandomValue(random, preparedStatement, 1, n, n2);
        BLOBTest.setRandomValue(random, preparedStatement, 2, n, n2);
        BLOBTest.setRandomValue(random, preparedStatement, 3, n, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.actionTypesCompareMainToAction(5);
        this.rollback();
    }

    public void testDerby2992_Repro() throws IOException, SQLException {
        this.setAutoCommit(true);
        this.getConnection().setTransactionIsolation(1);
        Statement statement = this.createStatement();
        this.dropTable("D2992BLOB");
        statement.executeUpdate("create table D2992BLOB (b blob)");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into D2992BLOB values (?)");
        int n = 0x4100000;
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n), n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select B from D2992BLOB");
        BLOBTest.assertTrue((boolean)resultSet.next());
        InputStream inputStream = resultSet.getBinaryStream(1);
        int n2 = inputStream.read();
        BLOBTest.assertTrue((n2 != -1 ? 1 : 0) != 0);
        Connection connection = this.openUserConnection("APP");
        Statement statement2 = connection.createStatement();
        BLOBTest.assertEquals((int)1, (int)statement2.executeUpdate("delete from D2992BLOB"));
        connection.close();
        byte[] byArray = new byte[4096];
        try {
            while (inputStream.read(byArray) != -1) {
            }
            BLOBTest.fail((String)"The read should have failed, value has been deleted");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public static void setRandomValue(Random random, PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException, IOException {
        Object object = BLOBTest.getRandomValue(random, n2, n3);
        if (object instanceof StringReaderWithLength) {
            StringReaderWithLength stringReaderWithLength = (StringReaderWithLength)object;
            preparedStatement.setCharacterStream(n, (Reader)stringReaderWithLength, stringReaderWithLength.getLength());
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            preparedStatement.setBinaryStream(n, inputStream, inputStream.available());
        } else {
            preparedStatement.setObject(n, object, n2);
        }
    }

    public static Object getRandomValue(Random random, int n, int n2) throws IOException {
        switch (n) {
            case 2004: {
                if (n2 > 262144) {
                    n2 = 262144;
                }
                return new ReadOnceByteArrayInputStream(BLOBTest.randomBinary(random, random.nextInt(n2)));
            }
        }
        BLOBTest.fail((String)("unexpected JDBC Type " + n));
        return null;
    }

    private static byte[] randomBinary(Random random, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)random.nextInt();
        }
        return byArray;
    }

    private void actionTypesCompareMainToAction(int n) throws SQLException, IOException {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        String string = "SELECT ID, V, V FROM T_MAIN ORDER BY 1";
        String string2 = "SELECT ID, V1, V2 FROM T_ACTION_ROW ORDER BY 1";
        String string3 = "SELECT ID, V1, V2 FROM T_ACTION_STATEMENT ORDER BY 1";
        ResultSet resultSet = statement.executeQuery(string);
        ResultSet resultSet2 = statement2.executeQuery(string2);
        JDBC.assertSameContents(resultSet, resultSet2);
        resultSet = statement.executeQuery(string);
        resultSet2 = statement2.executeQuery(string3);
        JDBC.assertSameContents(resultSet, resultSet2);
        this.assertTableRowCount("T_ACTION_ROW", n);
        this.assertTableRowCount("T_ACTION_STATEMENT", n);
        statement.close();
        statement2.close();
    }

    public void testDerby1511() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table derby1511(b blob)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into derby1511(b) values (?)");
        int n = 20;
        int n2 = 40000;
        for (int i = 0; i < n; ++i) {
            preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n2), n2);
            preparedStatement.executeUpdate();
        }
        this.commit();
        ResultSet resultSet = statement.executeQuery("select b from derby1511");
        for (int i = 0; i < n; ++i) {
            BLOBTest.assertTrue((String)"Too few rows", (boolean)resultSet.next());
            BLOBTest.assertEquals(new LoopingAlphabetStream(n2), resultSet.getBinaryStream(1));
            this.commit();
        }
        BLOBTest.assertFalse((String)"Too many rows", (boolean)resultSet.next());
        resultSet.close();
    }

    private void verifyNewValueInTable(int n, int n2) throws IOException, SQLException {
        BLOBTest.println("Verify new value in table: " + n);
        Statement statement = this.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + BLOBDataModelSetup.getBlobTableName() + " WHERE val = " + n);
        BLOBTest.println("Query executed, calling next");
        boolean bl = false;
        while (resultSet.next()) {
            BLOBTest.println("Next called, verifying row");
            BLOBTest.assertEquals((String)"Unexpected value in val column", (int)n, (int)resultSet.getInt(1));
            this.verifyBlob(n, n2, resultSet.getBlob(3));
            bl = true;
        }
        BLOBTest.assertTrue((String)("No column with value= " + n + " found "), (boolean)bl);
        resultSet.close();
        statement.close();
    }

    private void verifyBlob(int n, int n2, Blob blob) throws IOException, SQLException {
        InputStream inputStream = blob.getBinaryStream();
        int n3 = 0;
        int n4 = inputStream.read();
        while (n4 != -1) {
            ++n3;
            if (n != n4) {
                BLOBTest.assertEquals((String)("Unexpected value in stream at position " + n3), (int)n, (int)n4);
            }
            n4 = inputStream.read();
        }
        inputStream.close();
        BLOBTest.assertEquals((String)"Unexpected size of stream ", (int)n2, (int)n3);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(BLOBTest.class, "BLOBTest");
        return new BLOBDataModelSetup((Test)baseTestSuite);
    }

    public final void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
    }
}

