/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.demo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import toursdb.insertMaps;

public class CheckToursDBTest
extends BaseJDBCTestCase {
    public CheckToursDBTest(String name) {
        super(name);
    }

    public static Test basesuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(CheckToursDBTest.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/demo/cupisle.gif", "functionTests/tests/demo/smallisle.gif", "functionTests/tests/demo/witchisle.gif"});
        return test;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty CheckToursDBTest - *.setBigDecimal not supported with JSR169");
        }
        BaseTestSuite suite = new BaseTestSuite("CheckToursDBTest");
        suite.addTest(CheckToursDBTest.basesuite("CheckToursDBTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(CheckToursDBTest.basesuite("CheckToursDBTest:client")));
        return suite;
    }

    @Override
    protected void tearDown() throws Exception {
        Statement st = this.createStatement();
        st.execute("DROP TABLE AIRLINES");
        st.execute("DROP TABLE CITIES");
        st.execute("DROP TABLE COUNTRIES");
        st.execute("DROP TABLE FLIGHTAVAILABILITY");
        st.execute("DROP TABLE FLIGHTS");
        st.execute("DROP TABLE MAPS");
        st.execute("DROP TABLE FLIGHTS_HISTORY");
        st.close();
        this.commit();
        super.tearDown();
    }

    public void testToursDB() throws Exception {
        String[] dbfiles = new String[]{"ToursDB_schema.sql", "loadCOUNTRIES.sql", "loadCITIES.sql", "loadAIRLINES.sql", "loadFLIGHTS1.sql", "loadFLIGHTS2.sql", "loadFLIGHTAVAILABILITY1.sql", "loadFLIGHTAVAILABILITY2.sql"};
        for (int i = 0; i < dbfiles.length; ++i) {
            this.runScript("org/apache/derbyTesting/functionTests/tests/demo/" + dbfiles[i], "US-ASCII");
        }
        this.insertMapsPrivileged();
        this.doSelect();
        this.doUpdate();
        this.doDelete();
    }

    private void doDelete() throws Exception {
        String[] tableName = new String[]{"AIRLINES", "CITIES", "COUNTRIES", "FLIGHTAVAILABILITY", "FLIGHTS", "MAPS"};
        int[] expectedRows = new int[]{2, 87, 114, 518, 542, 3};
        PreparedStatement ps = null;
        for (int i = 0; i < 6; ++i) {
            ps = this.prepareStatement("delete from " + tableName[i]);
            CheckToursDBTest.assertEquals((int)ps.executeUpdate(), (int)expectedRows[i]);
        }
        ps = this.prepareStatement("select STATUS from FLIGHTS_HISTORY where FLIGHT_ID IS NULL and STATUS <> 'over'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "INSERTED FROM TRIG2");
        ps = this.prepareStatement("delete from FLIGHTS_HISTORY");
        CheckToursDBTest.assertEquals((int)ps.executeUpdate(), (int)2);
    }

    private void doUpdate() throws SQLException {
        PreparedStatement ps = null;
        ps = this.prepareStatement("select ECONOMY_SEATS from AIRLINES where AIRLINE = 'AA'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "20");
        Statement stmt = this.createStatement();
        stmt.execute("update AIRLINES set ECONOMY_SEATS=108 where AIRLINE = 'AA'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "108");
        ps = this.prepareStatement("select COUNTRY from COUNTRIES where COUNTRY_ISO_CODE = 'US'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "United States");
        stmt.execute("update COUNTRIES set COUNTRY='United States of America' where COUNTRY_ISO_CODE = 'US'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "United States of America");
        ps = this.prepareStatement("select COUNTRY from CITIES where CITY_ID = 52");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "United States");
        stmt.execute("update CITIES set COUNTRY='United States of America' where COUNTRY='United States'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "United States of America");
        ps = this.prepareStatement("select ECONOMY_SEATS_TAKEN from FLIGHTAVAILABILITY where FLIGHT_ID = 'AA1134' and FLIGHT_DATE='2004-03-31'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "2");
        stmt.execute("update FLIGHTAVAILABILITY set ECONOMY_SEATS_TAKEN=20 where FLIGHT_ID = 'AA1134' and FLIGHT_DATE='2004-03-31'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "20");
        ps = this.prepareStatement("select AIRCRAFT from FLIGHTS where FLIGHT_ID = 'AA1183'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "B747");
        stmt.execute("update FLIGHTS set AIRCRAFT='B777' where FLIGHT_ID = 'AA1134'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "B747");
        ps = this.prepareStatement("select REGION from MAPS where MAP_NAME = 'North Ocean'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "Cup Island");
        stmt.execute("update MAPS set REGION='Coffee Cup Island' where MAP_NAME = 'North Ocean'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "Coffee Cup Island");
        ps = this.prepareStatement("select STATUS from FLIGHTS_HISTORY where FLIGHT_ID = 'AA1134'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "INSERTED FROM TRIG1");
        stmt.execute("update FLIGHTS_HISTORY set STATUS='over' where FLIGHT_ID='AA1134'");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "over");
    }

    public void insertMapsPrivileged() throws Exception {
        this.insertMaps();
    }

    private void doSelect() throws SQLException {
        String[] expectedRows = new String[]{"2", "114", "87", "518", "542", "3", "0"};
        PreparedStatement ps = null;
        String[] tableName = new String[]{"AIRLINES", "COUNTRIES", "CITIES", "FLIGHTAVAILABILITY", "FLIGHTS", "MAPS", "FLIGHTS_HISTORY"};
        for (int i = 0; i < 7; ++i) {
            ps = this.prepareStatement("select count(*) from " + tableName[i]);
            JDBC.assertSingleValueResultSet(ps.executeQuery(), expectedRows[i]);
        }
    }

    private void insertMaps() throws SQLException, FileNotFoundException, IOException {
        Connection conn = this.getConnection();
        CheckToursDBTest.assertEquals((int)insertMaps.insertRows("extin", conn), (int)3);
    }
}

