/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;

public class MaxLogNumber {
    static final int COMMIT = 1;
    static final int ROLLBACK = 2;
    static final int NOACTION = 3;

    MaxLogNumber() {
    }

    private void runTest(Connection connection) throws SQLException {
        this.logMessage("Begin MaxLogNumber Test");
        this.performCheckPoint(connection);
        this.createTable(connection);
        this.insert(connection, 100, 1, 10);
        this.insert(connection, 100, 2, 10);
        this.update(connection, 50, 1, 10);
        this.update(connection, 50, 2, 10);
        this.verifyData(connection, 100);
        this.insert(connection, 2000, 3, 2000);
        this.logMessage("End MaxLogNumber Test");
    }

    void performCheckPoint(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        statement.close();
    }

    void insert(Connection connection, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO emp VALUES(?,?,?)");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "skywalker" + i);
            preparedStatement.setFloat(3, i * 2000);
            preparedStatement.executeUpdate();
            if (i % n3 != 0) continue;
            this.endTransaction(connection, n2);
        }
        this.endTransaction(connection, n2);
        preparedStatement.close();
    }

    void endTransaction(Connection connection, int n) throws SQLException {
        switch (n) {
            case 1: {
                connection.commit();
                break;
            }
            case 2: {
                connection.rollback();
                break;
            }
        }
    }

    void update(Connection connection, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("update emp SET salary=? where id=?");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setFloat(1, (float)((double)(i * 2000) * 0.08));
            preparedStatement.setInt(2, i);
            preparedStatement.executeUpdate();
            if (i % n3 != 0) continue;
            this.endTransaction(connection, n2);
        }
        this.endTransaction(connection, n2);
        preparedStatement.close();
    }

    void verifyData(Connection connection, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ID, name from emp order by id");
        int n2 = 0;
        int n3 = 0;
        while (resultSet.next()) {
            int n4 = resultSet.getInt(1);
            String string = resultSet.getString(2);
            if (string.equals("skywalker" + n3) && n4 != n3) {
                this.logMessage("DATA IN THE TABLE IS NOT AS EXPECTED");
                this.logMessage("Got :ID=" + n4 + " Name=:" + string);
                this.logMessage("Expected: ID=" + n3 + "Name=skywalker" + n3);
            }
            ++n3;
            ++n2;
        }
        if (n2 != n) {
            this.logMessage("Expected Number Of Rows (" + n + ")!=No Of rows in the Table(" + n2 + ")");
        }
        statement.close();
    }

    void createTable(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE emp(id INT,name CHAR(200),salary float)");
        statement.executeUpdate("create index emp_idx on emp(id) ");
        connection.commit();
        statement.close();
    }

    void logMessage(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) throws Throwable {
        MaxLogNumber maxLogNumber = new MaxLogNumber();
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        connection.setAutoCommit(false);
        try {
            maxLogNumber.runTest(connection);
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }
}

