/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class CharUTF8Test
extends BaseJDBCTestCase {
    private PreparedStatement psSet;
    private PreparedStatement psGet;

    public CharUTF8Test(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup((Test)new BaseTestSuite(CharUTF8Test.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE TEST(id int not null primary key, body varchar(60))");
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.psSet = this.prepareStatement("insert into test values(?,?)");
        this.psGet = this.prepareStatement("select body from test where id=?");
    }

    @Override
    protected void tearDown() throws Exception {
        this.psSet = null;
        this.psGet = null;
        super.tearDown();
    }

    public void testUTF8() throws SQLException {
        for (int i = 0; i <= 65535; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char)i);
            if (stringBuffer.length() != 60 && i != 65535) continue;
            String string = stringBuffer.toString();
            this.setBody(i, string);
            String string2 = this.getBody(i);
            CharUTF8Test.assertEquals((String)("Fetched string is incorrect (length = " + stringBuffer.length() + ")"), (String)string, (String)string2);
            stringBuffer.setLength(0);
        }
    }

    public void testEmptyStringUTF8() throws SQLException {
        this.setBody(-1, "");
        CharUTF8Test.assertEquals((String)"Empty string incorrect!", (String)"", (String)this.getBody(-1));
    }

    private void setBody(int n, String string) throws SQLException {
        this.psSet.setInt(1, n);
        this.psSet.setString(2, string);
        this.psSet.executeUpdate();
    }

    private String getBody(int n) throws SQLException {
        String string = "NO RESULT";
        this.psGet.setInt(1, n);
        ResultSet resultSet = this.psGet.executeQuery();
        if (resultSet.next()) {
            string = resultSet.getString(1);
        }
        resultSet.close();
        return string;
    }
}

