/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CheckConstraintTest
extends BaseJDBCTestCase {
    private static final String IMPORT_FILE_NAME = "t_bi_1.dat";
    static boolean funcWasCalled;

    public CheckConstraintTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("checkConstraint Test");
        suite.addTest(TestConfiguration.defaultSuite(CheckConstraintTest.class));
        return new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/lang/t_bi_1.dat"});
    }

    public void testNotAllowedInCheckConstraints() throws Exception {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        CheckConstraintTest.assertStatementError("42Y39", st, "create table neg1(c1 int check(?))");
        CheckConstraintTest.assertStatementError("42Y39", st, " create table neg1(c1 int check(c1 in (select c1 from neg1)))");
        CheckConstraintTest.assertStatementError("42Y39", st, " create table neg1(c1 int check(CURRENT_DATE = CURRENT_DATE))");
        CheckConstraintTest.assertStatementError("42Y39", st, " create table neg1(c1 int check(CURRENT_TIME = CURRENT_TIME))");
        CheckConstraintTest.assertStatementError("42Y39", st, " create table neg1(c1 int check(CURRENT_TIMESTAMP = CURRENT_TIMESTAMP))");
        CheckConstraintTest.assertStatementError("42X19", st, "create table neg1(c1 int check(c1))");
        CheckConstraintTest.assertStatementError("42X19", st, " create table neg1(c1 int check(1))");
        CheckConstraintTest.assertStatementError("42X19", st, " create table neg1(c1 int check(c1+c1))");
        CheckConstraintTest.assertStatementError("42X04", st, "create table neg1(c1 int check((c2 = 1)))");
        st.executeUpdate("create table t1(c1 int constraint asdf check(c1 = 1))");
        CheckConstraintTest.assertStatementError("42Y48", st, " select * from t1 --derby-properties constraint = asdf ");
        this.rollback();
        CheckConstraintTest.assertStatementError("42621", st, "create table neg1(c1 int check(c2 = 1), c2 int)");
        CheckConstraintTest.assertStatementError("42621", st, " create table neg2(c1 int constraint asdf check(c2 = 1), c2 int)");
        this.rollback();
    }

    public void testCheckConstraints() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table pos1(c1 int check(c1 > 0), constraint asdf check(c1 < 10))");
        CheckConstraintTest.assertStatementError("23513", st, "insert into pos1 values 0");
        st.executeUpdate(" insert into pos1 values 1");
        st.executeUpdate(" insert into pos1 values 9");
        CheckConstraintTest.assertStatementError("23513", st, " insert into pos1 values 10");
        ResultSet rs = st.executeQuery("select * from pos1");
        String[] expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"9"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertStatementError("23513", st, "update pos1 set c1 = c1 + 1");
        rs = st.executeQuery(" select * from pos1");
        expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"9"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertStatementError("23513", st, " update pos1 set c1 = c1 - 1");
        rs = st.executeQuery(" select * from pos1");
        expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"9"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
        st.executeUpdate("create table negcks(c1 int constraint ck1st check(c1 > 4), c2 int constraint ck2nd check(c2 > 2), c3 int, constraint ckLast check(c2 > c1))");
        CheckConstraintTest.assertStatementError("23513", st, "insert into negcks values (1, 3, 3)");
        CheckConstraintTest.assertStatementError("23513", st, "insert into negcks values (5, 1, 3)");
        CheckConstraintTest.assertStatementError("23513", st, "insert into negcks values (2, 3, 3)");
        this.rollback();
        st.executeUpdate("create table pos1(c1 int, c2 int, constraint ck1 check (c1 < c2))");
        st.executeUpdate(" insert into pos1 values (1, 2), (2, 3), (3, 4)");
        this.commit();
        st.executeUpdate("insert into pos1 select * from pos1");
        rs = st.executeQuery(" select count(*) from pos1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"6"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertUpdateCount(st, 6, " update pos1 set c2 = (select max(c1) from pos1), c1 = (select min(c2) from pos1)");
        rs = st.executeQuery(" select * from pos1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"2", "3"}, {"2", "3"}, {"2", "3"}, {"2", "3"}, {"2", "3"}, {"2", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
        CheckConstraintTest.assertStatementError("23513", st, "insert into pos1 select c2, c1 from pos1");
        rs = st.executeQuery(" select count(*) from pos1");
        expColNames = new String[]{"1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertStatementError("23513", st, " update pos1 set c2 = (select min(c1) from pos1), c1 = (select max(c2) from pos1)");
        rs = st.executeQuery(" select * from pos1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "2"}, {"2", "3"}, {"3", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" drop table pos1");
        this.commit();
        st.executeUpdate("create table t1(c1 int, c2 int, constraint ck1 check(c1 = c2))");
        CheckConstraintTest.assertStatementError("23513", st, " insert into t1 values (1, 1), (2, 1)");
        rs = st.executeQuery(" select * from t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        JDBC.assertDrainResults(rs, 0);
        st.executeUpdate("insert into t1 values (1.0, 1)");
        CheckConstraintTest.assertStatementError("23513", st, " insert into t1 values (2.0, 1)");
        rs = st.executeQuery(" select * from t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertUpdateCount(st, 1, " update t1 set c2 = 1.0");
        CheckConstraintTest.assertStatementError("23513", st, " update t1 set c2 = 2.0");
        rs = st.executeQuery(" select * from t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertUpdateCount(st, 1, " update t1 set c1 = 3.0, c2 = 3.0");
        rs = st.executeQuery(" select * from t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"3", "3"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
    }

    public void testPositionalUpdate() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t1(c1 int, c2 int, constraint ck1 check(c1 = c2), constraint ck2 check(c2=c1))");
        st.executeUpdate(" insert into t1 values (1, 1), (2, 2), (3, 3), (4, 4)");
        st.executeUpdate(" create index i1 on t1(c1)");
        Statement st1 = this.createStatement();
        st1.setCursorName("c1");
        ResultSet rs1 = st1.executeQuery("select * from t1 where c2=2 for update of C1");
        rs1.next();
        this.setAutoCommit(false);
        CheckConstraintTest.assertUpdateCount(st, 1, "update t1 set c1 = c1 where current of \"c1\"");
        CheckConstraintTest.assertStatementError("23513", st, "update t1 set c1 = c1 + 1 where current of \"c1\"");
        st1.close();
        rs1.close();
        Statement st2 = this.createStatement();
        st2.setCursorName("c2");
        ResultSet rs2 = st2.executeQuery("select * from t1 where c1 = 2 for update of c2");
        rs2.next();
        this.setAutoCommit(false);
        CheckConstraintTest.assertUpdateCount(st, 1, "update t1 set c2 = c2 where current of \"c2\"");
        CheckConstraintTest.assertStatementError("23513", st, "update t1 set c2 = c2 + 1 where current of \"c2\"");
        st2.close();
        rs2.close();
        Statement st3 = this.createStatement();
        st3.setCursorName("c3");
        ResultSet rs3 = st3.executeQuery("select * from t1 where c1 = 2 for update of c1, c2");
        rs3.next();
        this.setAutoCommit(false);
        CheckConstraintTest.assertUpdateCount(st, 1, "update t1 set c2 = c1, c1 = c2 where current of \"c3\"");
        CheckConstraintTest.assertStatementError("23513", st, "update t1 set c2 = c2 + 1, c1 = c1 + 3 where current of \"c3\"");
        CheckConstraintTest.assertUpdateCount(st, 1, "update t1 set c2 = c1 + 3, c1 = c2 + 3 where current of \"c3\"");
        st3.close();
        rs3.close();
        ResultSet rs = st.executeQuery("select * from t1");
        String[] expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1", "1"}, {"5", "5"}, {"3", "3"}, {"4", "4"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
        st.executeUpdate("create table t1(c1 int check((c1 + c1) = (c1 * c1) or (c1 + c1)/2 = (c1 * c1)), c2 int)");
        st.executeUpdate("insert into t1 values (1, 9), (2, 10)");
        CheckConstraintTest.assertUpdateCount(st, 2, "update t1 set c2 = c2 * c2");
        CheckConstraintTest.assertUpdateCount(st, 1, " update t1 set c1 = 2 where c1 = 1");
        CheckConstraintTest.assertUpdateCount(st, 2, " update t1 set c1 = 1 where c1 = 2");
        CheckConstraintTest.assertStatementError("23513", st, "update t1 set c1 = c2");
        rs = st.executeQuery(" select * from t1");
        expColNames = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1", "81"}, {"1", "100"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        this.rollback();
    }

    public void testBuiltInFunctions() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table charTab (c1 char(4) check(CHAR(c1) = c1))");
        st.executeUpdate(" insert into charTab values 'asdf'");
        st.executeUpdate(" insert into charTab values 'fdsa'");
        st.executeUpdate("create table intTab (c1 int check(INT(1) = c1))");
        st.executeUpdate(" insert into intTab values 1");
        CheckConstraintTest.assertStatementError("23513", st, "insert into intTab values 2");
        st.executeUpdate(" create table maxIntTab (c1 int check(INT(2147483647) > c1))");
        st.executeUpdate(" insert into maxIntTab values 1");
        CheckConstraintTest.assertStatementError("23513", st, "insert into maxIntTab values 2147483647");
        this.rollback();
        st.executeUpdate("create table t1(c1 int not null constraint asdf primary key)");
        st.executeUpdate(" insert into t1 values 1, 2, 3, 4, 5");
        this.commit();
        PreparedStatement pSt1 = this.prepareStatement("insert into t1 values 1");
        PreparedStatement pSt2 = this.prepareStatement("update t1 set c1 = 3 where c1 = 4");
        PreparedStatement pSt3 = this.prepareStatement("select * from t1");
        CheckConstraintTest.assertStatementError("23505", pSt1);
        CheckConstraintTest.assertStatementError("23505", pSt2);
        ResultSet rs = pSt3.executeQuery();
        String[] expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        Object[][] expRS = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" alter table t1 drop constraint asdf");
        this.rollback();
        CheckConstraintTest.assertStatementError("23505", pSt1);
        CheckConstraintTest.assertStatementError("23505", pSt2);
        rs = pSt3.executeQuery();
        expColNames = new String[]{"C1"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate(" drop table t1");
        st.executeUpdate("create table t1(c1 int constraint asdf check(c1 = 1))");
        PreparedStatement pSt = this.prepareStatement("insert into t1 values (?)");
        rs = st.executeQuery("values (1)");
        rs.next();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            pSt.setObject(i, rs.getObject(i));
        }
        CheckConstraintTest.assertUpdateCount(pSt, 1);
        st.executeUpdate("drop table t1");
        st.executeUpdate(" create table t1(active_flag char(2) check(active_flag IN ('Y', 'N')), araccount_active_flag char(2) check(araccount_active_flag IN ('Y', 'N')), automatic_refill_flag char(2) check(automatic_refill_flag IN ('Y', 'N')), call_when_ready_flag char(2) check(call_when_ready_flag IN ('Y', 'N')), compliance_flag char(2) check(compliance_flag IN ('Y', 'N')), delivery_flag char(2) check(delivery_flag IN ('Y', 'N')), double_count_flag char(2) check(double_count_flag IN ('Y', 'N')), gender_ind char(2) check(gender_ind IN ('M', 'F', 'U')), geriatric_flag char(2) check(geriatric_flag IN ('Y', 'N')), refuse_inquiry_flag char(2) check(refuse_inquiry_flag IN ('Y', 'N')), animal_flag char(2) check(animal_flag IN ('Y', 'N')), terminal_flag char(2) check(terminal_flag IN ('Y', 'N')), unit_flag char(2) check(unit_flag IN ('Y', 'N')), VIP_flag char(2) check(VIP_flag IN ('Y', 'N')), snap_cap_flag char(2) check(snap_cap_flag IN ('Y', 'N')), consent_on_file_flag char(2) check(consent_on_file_flag IN ('Y', 'N')), enlarged_SIG_flag char(2) check(enlarged_SIG_flag IN ('Y', 'N')),aquired_patient_flag char(2) check(aquired_patient_flag IN ('Y', 'N')))");
        st.executeUpdate("drop table t1");
        st.executeUpdate(" create table t1 (c1 int not null primary key, c2 int not null unique, c3 int check (c3>=0))");
        st.executeUpdate(" alter table t1 add column c4 int not null default 1");
        st.executeUpdate(" alter table t1 add constraint c4_unique UNIQUE(c4)");
        st.executeUpdate(" alter table t1 add column c5 int check(c5 >= 0)");
        rs = st.executeQuery(" select  c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T1'");
        expColNames = new String[]{"TYPE"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"P"}, {"U"}, {"C"}, {"U"}, {"C"}};
        JDBC.assertUnorderedResultSet(rs, expRS, true);
        CheckConstraintTest.assertStatementError("42Y55", st, " drop table t2");
        st.executeUpdate(" create table t2 (c21 int references t1)");
        rs = st.executeQuery(" select c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T2'");
        expColNames = new String[]{"TYPE"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"F"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertStatementError("42Y55", st, " drop table t3");
        st.executeUpdate(" create table t3 (c1 int check (c1 >= 0), c2 int check (c2 >= 0), c3 int check (c3 >= 0), c4 int check (c4 >= 0), c5 int check (c5 >= 0), c6 int check (c6 >= 0), c7 int check (c7 >= 0), c8 int check (c8 >= 0), c9 int check (c9 >= 0), c10 int check (c10 >= 0), c11 int check (c11 >= 0), c12 int check (c12 >= 0), c13 int check (c13 >= 0))");
        rs = st.executeQuery(" select c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T3'");
        expColNames = new String[]{"TYPE"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}, {"C"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        CheckConstraintTest.assertStatementError("42Y55", st, " drop table t4");
        st.executeUpdate(" create table t4(c11 int not null, c12 int not null, primary key (c11, c12))");
        rs = st.executeQuery(" select c.type from sys.sysconstraints c, sys.systables t where c.tableid = t.tableid and tablename='T4'");
        expColNames = new String[]{"TYPE"};
        JDBC.assertColumnNames(rs, expColNames);
        expRS = new String[][]{{"P"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        st.executeUpdate("drop table t4");
        st.executeUpdate("drop table t3");
        st.executeUpdate("drop table t2");
        st.executeUpdate("drop table t1");
        this.commit();
    }

    public void testJira2989() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("CREATE TABLE \"indicator\" (c CHAR(1) DEFAULT 'N')");
        st.executeUpdate(" ALTER TABLE  \"indicator\" ADD CONSTRAINT my_constraint CHECK ((c IN ('Y','N')))");
        st.executeUpdate(" INSERT INTO  \"indicator\" VALUES ('N')");
        st.executeUpdate(" ALTER TABLE  \"indicator\" DROP CONSTRAINT my_constraint");
        st.executeUpdate(" DROP TABLE   \"indicator\"");
        this.getConnection().rollback();
        st.close();
    }

    public void testJira4282() throws SQLException {
        if (CheckConstraintTest.usingEmbedded()) {
            return;
        }
        Statement st = this.createStatement();
        st.executeUpdate("create table t4282(c1 int, c2 int, constraint ck1 check(c1 = c2), constraint ck2 check(c2=c1))");
        st.executeUpdate("insert into t4282 values (1,1),(2,2),(3,3),(4,4)");
        Statement st1 = this.createStatement();
        st1.setCursorName("c1");
        ResultSet rs = st1.executeQuery("select * from t4282 for update");
        CheckConstraintTest.assertTrue((String)"Failed to retrieve row for update", (boolean)rs.next());
        st.executeUpdate("update t4282 set c1 = c1 where current of \"c1\"");
        st1.close();
        st.close();
        this.dropTable("t4282");
    }

    public void testPrimaryKeyPageSizeDerby3947() throws SQLException {
        Statement st = this.createStatement();
        st.executeUpdate("create table d3947 (x varchar(1000) primary key)");
        char[] chars = new char[994];
        PreparedStatement ps = this.prepareStatement("insert into d3947 values (?)");
        ps.setString(1, new String(chars));
        ps.executeUpdate();
        ps.close();
        this.checkLargePageSize(st, "D3947");
        st.executeUpdate("drop table d3947");
        st.executeUpdate("create table d3947 (x varchar(1000) not null,  y varchar(1000))");
        st.executeUpdate("alter table d3947 add constraint constraint1 primary key (x)");
        st.executeUpdate("alter table d3947 add constraint constraint2 foreign key (y) references d3947(x)");
        this.checkLargePageSize(st, "D3947");
        CheckConstraintTest.assertStatementError("42X14", st, "alter table d3947 add constraint constraint3 foreign key (z) references d3947(x)");
        st.executeUpdate("drop table d3947");
        st.close();
    }

    private void checkLargePageSize(Statement st, String tblName) throws SQLException {
        ResultSet rs = st.executeQuery("select * from TABLE(SYSCS_DIAG.SPACE_TABLE('" + tblName + "')) T");
        while (rs.next()) {
            if ("1".equals(rs.getString("isindex"))) {
                CheckConstraintTest.assertEquals((int)32768, (int)rs.getInt("pagesize"));
                continue;
            }
            CheckConstraintTest.assertEquals((int)4096, (int)rs.getInt("pagesize"));
        }
        rs.close();
    }

    public void testDerby6362() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create schema d6362_s1");
        s.execute("create schema d6362_s2");
        s.execute("set schema d6362_s1");
        s.execute("create function f(x int) returns int deterministic language java  parameter style java external name 'java.lang.Math.abs' no sql");
        s.execute("create type typ external name 'java.util.ArrayList' language java");
        s.execute("create table d6362_s2.t(x int, constraint c001 check(f(x) < 3))");
        s.execute("alter table d6362_s2.t add constraint c002 check(f(x) >= 0)");
        s.execute("alter table d6362_s2.t add constraint c003 check(cast(null as typ) is null)");
        s.execute("alter table d6362_s2.t add constraint c004 check(f(x) > cos(pi()))");
        s.execute("alter table d6362_s2.t add constraint c005 check(abs(f(x)) < pi())");
        s.execute("set schema d6362_s2");
        s.execute("alter table t add constraint c101 check(x < 3)");
        s.execute("alter table t add constraint c102 check(t.x < 4)");
        s.execute("alter table t add constraint c103 check(x <= d6362_s1.f(t.x))");
        s.execute("alter table t add constraint c201 check(d6362_s2.t.x < 5)");
        s.execute("alter table t add constraint c202 check(d6362_s1.f(x) < 5)");
        s.execute("alter table t add constraint c203 check(cast(null as d6362_s1.typ) is null)");
        String[][] expectedConstraints = new String[][]{{"C001", "(\"D6362_S1\".\"F\"(x) < 3)"}, {"C002", "(\"D6362_S1\".\"F\"(x) >= 0)"}, {"C003", "(cast(null as \"D6362_S1\".\"TYP\") is null)"}, {"C004", "(\"D6362_S1\".\"F\"(x) > \"SYSFUN\".\"COS\"(\"SYSFUN\".\"PI\"()))"}, {"C005", "(abs(\"D6362_S1\".\"F\"(x)) < \"SYSFUN\".\"PI\"())"}, {"C101", "(x < 3)"}, {"C102", "(\"D6362_S2\".\"T\".x < 4)"}, {"C103", "(x <= \"D6362_S1\".\"F\"(\"D6362_S2\".\"T\".x))"}, {"C201", "(\"D6362_S2\".\"T\".x < 5)"}, {"C202", "(\"D6362_S1\".\"F\"(x) < 5)"}, {"C203", "(cast(null as \"D6362_S1\".\"TYP\") is null)"}};
        JDBC.assertFullResultSet(s.executeQuery("select constraintname, checkdefinition from sys.syschecks natural join sys.sysconstraints natural join sys.sysschemas where schemaname = 'D6362_S2' and type = 'C' order by constraintname"), expectedConstraints);
        s.execute("insert into t values 1,2");
        CheckConstraintTest.assertStatementError("23513", s, "insert into t values -10");
        CheckConstraintTest.assertStatementError("23513", s, "insert into t values 10");
    }

    private void setupForBulkInsert(Statement s, int limit) throws SQLException {
        s.executeUpdate("create table t_bi_1( a int, b int check (b < " + limit + "))");
        s.executeUpdate("create function func () returns int     language java parameter style java deterministic no sql     external name '" + ((Object)((Object)this)).getClass().getName() + ".func'");
    }

    public void testbulkInsert() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        this.setupForBulkInsert(s, 0);
        CheckConstraintTest.assertStatementError("23513", s, "call syscs_util.syscs_import_data(     null,     'T_BI_1',     'A, B',     '1, 2',     'extin/t_bi_1.dat',     null, null, null, 0 )");
        this.setupForBulkInsert(s, 10);
        s.executeUpdate("create trigger dagstrigger no cascade before insert on t_bi_1     values func() ");
        funcWasCalled = false;
        s.executeUpdate("call syscs_util.syscs_import_data(     null,     'T_BI_1',     'A, B',     '1, 2',     'extin/t_bi_1.dat',     null, null, null, 0 )");
        CheckConstraintTest.assertTrue((boolean)funcWasCalled);
    }

    public static int func() {
        funcWasCalled = true;
        return 0;
    }
}

