/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.w3c.dom.Element;

abstract class BasicNoPutResultSetImpl
implements NoPutResultSet {
    protected boolean isOpen;
    protected boolean finished;
    protected ExecRow currentRow;
    protected boolean isTopResultSet;
    private SQLWarning warnings;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    protected long startExecutionTime;
    protected long endExecutionTime;
    public long beginTime;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private StatementContext statementContext;
    public NoPutResultSet[] subqueryTrackingArray;
    ExecRow compactRow;
    protected final Activation activation;
    private final boolean statisticsTimingOn;
    ResultDescription resultDescription;
    private transient TransactionController tc;
    private int[] baseColumnMap;

    BasicNoPutResultSetImpl(ResultDescription resultDescription, Activation activation, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        this.activation = activation;
        this.statisticsTimingOn = this.getLanguageConnectionContext().getStatisticsTiming();
        if (this.statisticsTimingOn) {
            this.beginTime = this.startExecutionTime = this.getCurrentTimeMillis();
        }
        this.resultDescription = resultDescription;
        this.optimizerEstimatedRowCount = optimizerEstimatedRowCount;
        this.optimizerEstimatedCost = optimizerEstimatedCost;
    }

    protected final void recordConstructorTime() {
        if (this.statisticsTimingOn) {
            this.constructorTime = this.getElapsedMillis(this.beginTime);
        }
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    protected final boolean isXplainOnlyMode() {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        return lcc.getRunTimeStatisticsMode() && lcc.getXplainOnlyMode();
    }

    @Override
    public void reopenCore() throws StandardException {
        this.close();
        this.openCore();
    }

    @Override
    public abstract ExecRow getNextRowCore() throws StandardException;

    @Override
    public int getPointOfAttachment() {
        SanityManager.THROWASSERT("getPointOfAttachment() not expected to be called for " + this.getClass().getName());
        return -1;
    }

    @Override
    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    @Override
    public int getScanIsolationLevel() {
        SanityManager.THROWASSERT("getScanIsolationLevel() not expected to be called for " + this.getClass().getName());
        return 0;
    }

    @Override
    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    @Override
    public boolean requiresRelocking() {
        SanityManager.THROWASSERT("requiresRelocking() not expected to be called for " + this.getClass().getName());
        return false;
    }

    @Override
    public final void open() throws StandardException {
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        this.finished = false;
        this.attachStatementContext();
        try {
            this.openCore();
        }
        catch (StandardException se) {
            this.activation.checkStatementValidity();
            throw se;
        }
        this.activation.checkStatementValidity();
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "absolute");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getAbsoluteRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "relative");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getRelativeRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("setBeforeFirstRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    @Override
    public boolean checkRowPosition(int isType) throws StandardException {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getFirstRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "previous");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getPreviousRow() not expected to be called.");
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "last");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getLastRow() not expected to be called.");
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "last");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("setAfterLastRow() not expected to be called.");
        return null;
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public final long modifiedRowCount() {
        return 0L;
    }

    @Override
    public void cleanUp() throws StandardException {
        if (this.isOpen) {
            this.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    protected final void finishAndRTS() throws StandardException {
        if (!this.finished) {
            if (!this.isClosed()) {
                this.close();
            }
            this.finished = true;
            if (this.isTopResultSet && this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    @Override
    public long getExecuteTime() {
        return this.getTimeSpent(1);
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.startExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.startExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    protected final long getElapsedMillis(long beginTime) {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis() - beginTime;
        }
        return 0L;
    }

    protected final String dumpTimeStats(String indent, String subIndent) {
        return indent + MessageService.getTextMessage("42Z30.U", new Object[0]) + " " + this.getTimeSpent(0) + "\n" + indent + MessageService.getTextMessage("42Z31.U", new Object[0]) + " " + this.getTimeSpent(1) + "\n" + indent + MessageService.getTextMessage("42Z32.U", new Object[0]) + "\n" + subIndent + MessageService.getTextMessage("42Z33.U", new Object[0]) + " " + this.constructorTime + "\n" + subIndent + MessageService.getTextMessage("42Z34.U", new Object[0]) + " " + this.openTime + "\n" + subIndent + MessageService.getTextMessage("42Z35.U", new Object[0]) + " " + this.nextTime + "\n" + subIndent + MessageService.getTextMessage("42Z36.U", new Object[0]) + " " + this.closeTime;
    }

    protected void attachStatementContext() throws StandardException {
        if (this.isTopResultSet) {
            if (this.statementContext == null || !this.statementContext.onStack()) {
                this.statementContext = this.getLanguageConnectionContext().getStatementContext();
            }
            this.statementContext.setTopResultSet(this, this.subqueryTrackingArray);
            if (this.subqueryTrackingArray == null) {
                this.subqueryTrackingArray = this.statementContext.getSubqueryTrackingArray();
            }
            this.statementContext.setActivation(this.activation);
        }
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        return this.getActivation().getLanguageConnectionContext();
    }

    @Override
    public int resultSetNumber() {
        SanityManager.THROWASSERT("resultSetNumber() should not be called on a " + this.getClass().getName());
        return 0;
    }

    final ExecutionFactory getExecutionFactory() {
        return this.activation.getExecutionFactory();
    }

    final TransactionController getTransactionController() {
        if (this.tc == null) {
            this.tc = this.getLanguageConnectionContext().getTransactionExecute();
        }
        return this.tc;
    }

    protected ExecRow getCompactRow(ExecRow candidate, FormatableBitSet accessedCols, boolean isKeyed) throws StandardException {
        int numCandidateCols = candidate.nColumns();
        if (accessedCols == null) {
            this.compactRow = candidate;
            this.baseColumnMap = new int[numCandidateCols];
            for (int i = 0; i < this.baseColumnMap.length; ++i) {
                this.baseColumnMap[i] = i;
            }
        } else {
            int numCols = accessedCols.getNumBitsSet();
            this.baseColumnMap = new int[numCols];
            if (this.compactRow == null) {
                ExecutionFactory ex = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
                this.compactRow = isKeyed ? ex.getIndexableRow(numCols) : ex.getValueRow(numCols);
            }
            int position = 0;
            int i = accessedCols.anySetBit();
            while (i != -1 && i < numCandidateCols) {
                DataValueDescriptor sc = candidate.getColumn(i + 1);
                if (sc != null) {
                    this.compactRow.setColumn(position + 1, sc);
                }
                this.baseColumnMap[position] = i;
                ++position;
                i = accessedCols.anySetBit(i);
            }
        }
        return this.compactRow;
    }

    protected ExecRow setCompactRow(ExecRow candidateRow, ExecRow compactRow) {
        ExecRow retval;
        if (this.baseColumnMap == null) {
            retval = candidateRow;
        } else {
            retval = compactRow;
            this.setCompatRow(compactRow, candidateRow.getRowArray());
        }
        return retval;
    }

    protected final void setCompatRow(ExecRow compactRow, DataValueDescriptor[] sourceRow) {
        DataValueDescriptor[] destRow = compactRow.getRowArray();
        int[] lbcm = this.baseColumnMap;
        for (int i = 0; i < lbcm.length; ++i) {
            destRow[i] = sourceRow[lbcm[i]];
        }
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    public void checkCancellationFlag() throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        StatementContext localStatementContext = lcc.getStatementContext();
        if (localStatementContext == null) {
            return;
        }
        InterruptStatus.throwIf(lcc);
        if (localStatementContext.isCancelled()) {
            throw StandardException.newException("XCL52.S", new Object[0]);
        }
    }

    @Override
    public final void addWarning(SQLWarning w) {
        ResultSet rs;
        if (this.isTopResultSet) {
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return;
        }
        if (this.activation != null && (rs = this.activation.getResultSet()) != null) {
            rs.addWarning(w);
        }
    }

    @Override
    public final SQLWarning getWarnings() {
        SQLWarning w = this.warnings;
        this.warnings = null;
        return w;
    }

    @Override
    public Element toXML(Element parentNode, String tag) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(parentNode, tag, this), this);
    }

    public static Element toXML(Element parentNode, String childTag, ResultSet rs) throws Exception {
        Element result = parentNode.getOwnerDocument().createElement(childTag);
        result.setAttribute("type", BasicNoPutResultSetImpl.stripPackage(rs.getClass().getName()));
        parentNode.appendChild(result);
        return result;
    }

    private static String stripPackage(String className) {
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static Element childrenToXML(Element outerNode, ResultSet outerRS) throws Exception {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        BasicNoPutResultSetImpl.findResultSetFields(fieldList, outerRS.getClass());
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        Arrays.sort(fields, new FieldComparator());
        for (Field field : fields) {
            Object fieldContents = field.get(outerRS);
            if (fieldContents == null) continue;
            if (field.getType().isArray()) {
                Element arrayNode = outerNode.getOwnerDocument().createElement("array");
                arrayNode.setAttribute("arrayName", field.getName());
                String typeName = BasicNoPutResultSetImpl.stripPackage(field.getType().getComponentType().getName()) + "[]";
                arrayNode.setAttribute("type", typeName);
                outerNode.appendChild(arrayNode);
                int arrayLength = Array.getLength(fieldContents);
                for (int i = 0; i < arrayLength; ++i) {
                    ResultSet cellRS = (ResultSet)Array.get(fieldContents, i);
                    if (cellRS == null) continue;
                    Element cellNode = cellRS.toXML(arrayNode, "cell");
                    cellNode.setAttribute("cellNumber", Integer.toString(i));
                }
                continue;
            }
            ResultSet innerRS = (ResultSet)fieldContents;
            innerRS.toXML(outerNode, field.getName());
        }
        return outerNode;
    }

    private static void findResultSetFields(ArrayList<Field> fieldList, final Class<?> klass) throws Exception {
        Field[] fields;
        if (klass == null) {
            return;
        }
        for (Field field : fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return klass.getDeclaredFields();
            }
        })) {
            if (ResultSet.class.isAssignableFrom(field.getType())) {
                fieldList.add(field);
                continue;
            }
            if (!field.getType().isArray() || !ResultSet.class.isAssignableFrom(field.getType().getComponentType())) continue;
            fieldList.add(field);
        }
        BasicNoPutResultSetImpl.findResultSetFields(fieldList, klass.getSuperclass());
    }

    public static final class FieldComparator
    implements Comparator<Field> {
        @Override
        public int compare(Field left, Field right) {
            return left.getName().compareTo(right.getName());
        }
    }
}

