/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.Test;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.VirtualFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.unitTests.junit.PathUtilTest;

public class VirtualFileTest
extends BaseTestCase {
    private final String[] NON_EXISTING_DIRS = new String[]{"this", "dir", "does", "not", "exist"};
    private static int dbStoreIndex = 0;

    public VirtualFileTest(String name) {
        super(name);
    }

    public void testCreateFileInRoot() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("service.properties", store);
        VirtualFileTest.assertFalse((boolean)new VirtualFile("service.properties", store).exists());
        VirtualFileTest.assertFalse((boolean)vFile.exists());
    }

    public void testCreateDirInRoot() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("seg0", store);
        VirtualFileTest.assertFalse((boolean)vFile.exists());
        vFile.mkdir();
        VirtualFileTest.assertTrue((boolean)vFile.exists());
        VirtualFileTest.assertTrue((boolean)vFile.isDirectory());
    }

    public void testCreateInvalidDir() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile(PathUtilTest.join(this.NON_EXISTING_DIRS), store);
        VirtualFileTest.assertFalse((boolean)vFile.exists());
        VirtualFile tmp = new VirtualFile("", store);
        VirtualFileTest.assertTrue((boolean)tmp.mkdir());
        VirtualFileTest.assertFalse((String)"Dir creation should have failed", (boolean)vFile.mkdir());
    }

    public void testMkdirsValidRelative() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile(PathUtilTest.join(this.NON_EXISTING_DIRS), store);
        VirtualFileTest.assertTrue((boolean)vFile.mkdirs());
    }

    public void testMkdirsValidAbsolute() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile(PathUtilTest.joinAbs(this.NON_EXISTING_DIRS), store);
        VirtualFileTest.assertTrue((boolean)vFile.mkdirs());
    }

    public void testMkdirsInvalidAbsolute() throws IOException {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile tmp = new VirtualFile(PathUtilTest.abs("directory"), store);
        VirtualFileTest.assertTrue((boolean)tmp.mkdir());
        tmp = new VirtualFile(PathUtilTest.joinAbs("directory", "afile"), store);
        VirtualFileTest.assertTrue((boolean)tmp.createNewFile());
        VirtualFileTest.assertTrue((boolean)tmp.exists());
        VirtualFileTest.assertFalse((boolean)tmp.isDirectory());
        VirtualFile vFile = new VirtualFile(PathUtilTest.joinAbs("directory", "afile", "anotherdir"), store);
        VirtualFileTest.assertFalse((boolean)vFile.mkdir());
        VirtualFileTest.assertFalse((boolean)vFile.mkdirs());
    }

    public void testMkdirsInvalidRelative() throws IOException {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile tmp = new VirtualFile("seg0", store);
        VirtualFileTest.assertTrue((boolean)tmp.mkdir());
        tmp = new VirtualFile(PathUtilTest.join("seg0", "datafile"), store);
        VirtualFileTest.assertTrue((boolean)tmp.createNewFile());
        VirtualFileTest.assertTrue((boolean)tmp.exists());
        VirtualFileTest.assertFalse((boolean)tmp.isDirectory());
        VirtualFile vFile = new VirtualFile(PathUtilTest.join("seg0", "datafile", "anotherdir"), store);
        VirtualFileTest.assertFalse((boolean)vFile.mkdir());
        VirtualFileTest.assertFalse((boolean)vFile.mkdirs());
    }

    public void testGetParentRelative() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile(PathUtilTest.join(this.NON_EXISTING_DIRS), store);
        int count = 0;
        for (StorageFile parent = vFile.getParentDir(); parent != null; parent = parent.getParentDir()) {
            ++count;
        }
        VirtualFileTest.assertEquals((int)4, (int)count);
    }

    public void testGetParentAbsolute() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile(PathUtilTest.joinAbs(this.NON_EXISTING_DIRS), store);
        int count = 0;
        for (StorageFile parent = vFile.getParentDir(); parent != null; parent = parent.getParentDir()) {
            ++count;
        }
        VirtualFileTest.assertEquals((int)5, (int)count);
    }

    public void testDeleteAll() throws IOException {
        int i;
        DataStore store = VirtualFileTest.getStore();
        String[] dirs = new String[]{"seg0", PathUtilTest.join("seg0", "dir1"), "seg1", PathUtilTest.join("seg0", "dir2")};
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            VirtualFileTest.assertTrue((boolean)new VirtualFile(dirs[i2], store).mkdir());
        }
        String[] files = new String[]{PathUtilTest.join("seg0", "f1"), PathUtilTest.join("seg0", "dir1", "f1"), PathUtilTest.join("seg1", "f1"), PathUtilTest.join("seg0", "f5")};
        for (int i3 = 0; i3 < files.length; ++i3) {
            VirtualFileTest.assertTrue((boolean)new VirtualFile(files[i3], store).createNewFile());
        }
        String root = "seg0";
        VirtualFile rootToDelete = new VirtualFile(root, store);
        VirtualFileTest.assertTrue((boolean)rootToDelete.deleteAll());
        for (i = 0; i < dirs.length; ++i) {
            VirtualFileTest.assertEquals((!dirs[i].startsWith(root) ? 1 : 0) != 0, (boolean)new VirtualFile(dirs[i], store).exists());
        }
        for (i = 0; i < files.length; ++i) {
            VirtualFileTest.assertEquals((!files[i].startsWith(root) ? 1 : 0) != 0, (boolean)new VirtualFile(files[i], store).exists());
        }
    }

    public void testRenameToSimple() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("originalFile", store);
        VirtualFileTest.assertFalse((boolean)vFile.canWrite());
        vFile.createNewFile();
        VirtualFileTest.assertTrue((boolean)vFile.canWrite());
        VirtualFile newFile = new VirtualFile("newFile", store);
        VirtualFileTest.assertFalse((boolean)newFile.exists());
        VirtualFileTest.assertTrue((boolean)vFile.renameTo((StorageFile)newFile));
        VirtualFileTest.assertFalse((boolean)vFile.exists());
        VirtualFileTest.assertFalse((boolean)vFile.canWrite());
        VirtualFileTest.assertTrue((boolean)newFile.exists());
    }

    public void testGetRAFNonExisting() throws FileNotFoundException {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("aNewFile.txt", store);
        VirtualFileTest.assertFalse((boolean)vFile.exists());
        StorageRandomAccessFile vRAF = vFile.getRandomAccessFile("rw");
        VirtualFileTest.assertNotNull((Object)vRAF);
        VirtualFileTest.assertTrue((boolean)vFile.exists());
    }

    public void testGetRAFNonExistingReadMode() throws FileNotFoundException {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("aNewFile.txt", store);
        VirtualFileTest.assertFalse((boolean)vFile.exists());
        try {
            vFile.getRandomAccessFile("r");
            VirtualFileTest.fail((String)"Cannot read from a non-exsiting file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        VirtualFileTest.assertFalse((boolean)vFile.exists());
    }

    public void testGetRAExistingReadOnly() throws FileNotFoundException {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("aNewFile.txt", store);
        VirtualFileTest.assertFalse((boolean)vFile.exists());
        VirtualFileTest.assertTrue((boolean)vFile.createNewFile());
        VirtualFileTest.assertTrue((boolean)vFile.exists());
        VirtualFileTest.assertTrue((boolean)vFile.setReadOnly());
        VirtualFileTest.assertNotNull((Object)vFile.getRandomAccessFile("r"));
        try {
            vFile.getRandomAccessFile("rw");
            VirtualFileTest.fail((String)"Should not be able to open a read-only file in write mode");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testGetRAFOnDirectory() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile vFile = new VirtualFile("mydir", store);
        VirtualFileTest.assertTrue((boolean)vFile.mkdir());
        VirtualFileTest.assertTrue((boolean)vFile.exists());
        VirtualFileTest.assertTrue((boolean)vFile.isDirectory());
        try {
            vFile.getRandomAccessFile("r");
            VirtualFileTest.fail((String)"Opening a RAF on a directory should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            vFile.getRandomAccessFile("r");
            VirtualFileTest.fail((String)"Opening a RAF on a directory should have failed");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        VirtualFileTest.assertTrue((boolean)vFile.exists());
        VirtualFileTest.assertTrue((boolean)vFile.isDirectory());
    }

    public void testListChilderen() {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile dir1 = new VirtualFile(PathUtilTest.abs("mydir"), store);
        VirtualFile dir2 = new VirtualFile(PathUtilTest.abs("mydirectory"), store);
        VirtualFile file1 = new VirtualFile(PathUtilTest.joinAbs("mydir", "file1.txt"), store);
        VirtualFile file2 = new VirtualFile(PathUtilTest.joinAbs("mydirectory", "file2.txt"), store);
        VirtualFileTest.assertTrue((boolean)dir1.mkdirs());
        VirtualFileTest.assertTrue((boolean)dir1.exists());
        VirtualFileTest.assertTrue((boolean)dir1.isDirectory());
        VirtualFileTest.assertTrue((boolean)dir2.mkdirs());
        VirtualFileTest.assertTrue((boolean)dir2.exists());
        VirtualFileTest.assertTrue((boolean)dir2.isDirectory());
        VirtualFileTest.assertTrue((boolean)file1.createNewFile());
        VirtualFileTest.assertTrue((boolean)file1.exists());
        VirtualFileTest.assertFalse((boolean)file1.isDirectory());
        VirtualFileTest.assertTrue((boolean)file2.createNewFile());
        VirtualFileTest.assertTrue((boolean)file2.exists());
        VirtualFileTest.assertFalse((boolean)file2.isDirectory());
        String[] children = dir1.list();
        VirtualFileTest.assertEquals((int)1, (int)children.length);
        VirtualFileTest.assertEquals((String)file1.getName(), (String)children[0]);
        VirtualFile dir1abs = new VirtualFile(PathUtilTest.joinAbs("mydir", ""), store);
        VirtualFileTest.assertFalse((boolean)dir1.getName().equals(dir1abs.getName()));
        String[] childrenAbs = dir1abs.list();
        VirtualFileTest.assertEquals((int)1, (int)childrenAbs.length);
        VirtualFileTest.assertEquals((String)children[0], (String)childrenAbs[0]);
        VirtualFileTest.assertFalse((boolean)dir1.delete());
        VirtualFileTest.assertTrue((boolean)dir1.deleteAll());
        VirtualFileTest.assertTrue((boolean)dir2.exists());
        VirtualFileTest.assertTrue((boolean)file2.exists());
    }

    public void testCreateRoot() {
        DataStore store = new DataStore("testCreateRootStore");
        String path = PathUtilTest.joinAbs("these", "are", "directories");
        VirtualFileTest.assertTrue((boolean)store.createAllParents(path));
        VirtualFileTest.assertNotNull((Object)store.createEntry(path, true));
        VirtualFile vf = new VirtualFile(path, store);
        VirtualFileTest.assertTrue((boolean)vf.exists());
        VirtualFileTest.assertTrue((boolean)vf.isDirectory());
        path = PathUtilTest.join("c:", "Documents and Settings", "directories");
        VirtualFileTest.assertTrue((boolean)store.createAllParents(path));
        VirtualFileTest.assertNotNull((Object)store.createEntry(path, true));
        vf = new VirtualFile(path, store);
        VirtualFileTest.assertTrue((boolean)vf.exists());
        VirtualFileTest.assertTrue((boolean)vf.isDirectory());
    }

    public void testCloseIdempotent() throws IOException {
        DataStore store = VirtualFileTest.getStore();
        VirtualFile f = new VirtualFile("afile", store);
        StorageRandomAccessFile raf = f.getRandomAccessFile("rw");
        raf.close();
        raf.close();
    }

    public static Test suite() {
        return new BaseTestSuite(VirtualFileTest.class);
    }

    private static synchronized DataStore getStore() {
        DataStore store = new DataStore("testVFMemDB-" + dbStoreIndex++);
        VirtualFileTest.assertNotNull((Object)store.createEntry(File.separator, true));
        return store;
    }
}

