/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.XML;

public class EnvTest
extends TestCase {
    public EnvTest(String name) {
        super(name);
    }

    public void traceit(String text) {
        this.setName(text);
        PrintStream out = System.out;
        String KEY_TRACE = "derby.tests.trace";
        if (Boolean.valueOf(EnvTest.getSystemProperties().getProperty(KEY_TRACE)).booleanValue()) {
            out.println(text);
        }
    }

    public static final Properties getSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    public void testJSR169() {
        this.traceit(String.valueOf(JDBC.vmSupportsJSR169()) + "_vmSupportsJSR169()");
    }

    public void testJDBC3() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC3()) + "_vmSupportsJDBC3()");
    }

    public void testJDBC4() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC4()) + "_vmSupportsJDBC4()");
    }

    public void testJDBC41() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC41()) + "_vmSupportsJDBC41()");
    }

    public void testJDBC42() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC42()) + "_vmSupportsJDBC42()");
    }

    public void testHasServer() {
        this.traceit(String.valueOf(Derby.hasServer() + "_hasServer"));
    }

    public void testHasClient() {
        this.traceit(String.valueOf(Derby.hasClient() + "_hasClient"));
    }

    public void testHasEmbedded() {
        this.traceit(String.valueOf(Derby.hasEmbedded() + "_hasEmbedded"));
    }

    public void testHasTools() {
        this.traceit(String.valueOf(Derby.hasTools() + "_hasTools"));
    }

    public void testClasspathHasXalanAndJAXP() {
        this.traceit(String.valueOf(XML.classpathHasJAXP() + "_classpathHasJAXP"));
    }

    public void testClasspathMeetsXMLReqs() {
        this.traceit(String.valueOf(XML.classpathMeetsXMLReqs() + "_classpathMeetsXMLReqs"));
    }

    public void testHasLuceneCoreJar() {
        this.traceit(String.valueOf(JDBC.HAVE_LUCENE_CORE + "_hasLuceneCore"));
    }

    public void testHasLuceneQueryParserJar() {
        this.traceit(String.valueOf(JDBC.HAVE_LUCENE_QUERYPARSER + "_hasLuceneQueryParser"));
    }

    public void testHasLuceneAnalyzersJar() {
        this.traceit(String.valueOf(JDBC.HAVE_LUCENE_ANALYZERS + "_hasLuceneAnalyzers"));
    }

    public void testHasLDAPConfig() {
        Properties props = EnvTest.getSystemProperties();
        ArrayList<String> ldapSettings = new ArrayList<String>();
        ldapSettings.add(props.getProperty("derbyTesting.ldapPassword"));
        ldapSettings.add(props.getProperty("derbyTesting.ldapServer"));
        ldapSettings.add(props.getProperty("derbyTesting.ldapPort"));
        ldapSettings.add(props.getProperty("derbyTesting.dnString"));
        ldapSettings.add(props.getProperty("derbyTesting.ldapContextFactory"));
        boolean sofarsogood = true;
        for (String s : ldapSettings) {
            if (s != null && s.length() != 0 && !s.isEmpty()) continue;
            sofarsogood = false;
            break;
        }
        this.traceit(String.valueOf(sofarsogood) + "_hasLDAPConfiguration");
    }

    public void testHasJNDISupport() {
        this.traceit(String.valueOf(JDBC.vmSupportsJNDI() + "_classpathMeetsJNDIReqs"));
    }

    public void testHasBasicEncryptionSupport() {
        try {
            MessageDigest.getInstance("SHA-256");
            this.traceit("true_hasBasicEncryptionAlgorithmSupport");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.traceit("false_hasBasicEncryptionAlgorithmSupport");
        }
    }

    public void testHasSubStandardEncryptionSupport() {
        try {
            MessageDigest.getInstance("SHA-1");
            this.traceit("true_hasSubstandardEncryptionAlgorithmSupport");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.traceit("false_hasSubStandardEncryptionAlgorithmSupport");
        }
    }
}

