/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.util.Arrays;
import java.util.Random;
import org.apache.derbyTesting.junit.BaseTestCase;

public class ClusMog {
    public static final int max_n = 6;
    public int n = 0;
    public final double[] weight = new double[6];
    public final double[] mean = new double[6];
    public final double[] var = new double[6];
    protected int[] bracket = new int[7];
    protected int ns = 0;
    protected double[] sample = null;
    public static final int min_sample_size_per_cluster = 32;

    public void cluster(int n, double[] center, int ns, double[] sample) {
        this.setCenters(n, center);
        this.setSamples(ns, sample);
        this.initEM();
        double thresh = 1.0E-6;
        double oldmsr = Double.MAX_VALUE;
        int it = 1;
        while (true) {
            this.expectation();
            this.maximization();
            double msr = this.measure();
            double dif = Math.abs(msr - oldmsr);
            double err = dif / (1.0 + oldmsr);
            oldmsr = msr;
            if (err < 1.0E-6) break;
            ++it;
        }
        this.computeWeights();
        this.printMog("JAVA-COMPUTED", n, this.weight, this.mean, this.var);
        BaseTestCase.println("msr = (" + oldmsr + ")");
    }

    public static void uniform(int n, double[] center, int ns, double[] sample) {
        double min_x = Double.MAX_VALUE;
        double max_x = -1.7976931348623157E308;
        for (int i = 0; i < ns; ++i) {
            double x = sample[i];
            if (min_x > x) {
                min_x = x;
            }
            if (!(max_x < x)) continue;
            max_x = x;
        }
        double length = max_x - min_x;
        double increment = length / (double)n;
        center[0] = increment / 2.0;
        for (int i = 1; i < n; ++i) {
            center[i] = center[i - 1] + increment;
        }
    }

    public static void random(int n, double[] center, int ns, double[] sample, Random rng) {
        double min_x = Double.MAX_VALUE;
        double max_x = -1.7976931348623157E308;
        for (int i = 0; i < ns; ++i) {
            double x = sample[i];
            if (min_x > x) {
                min_x = x;
            }
            if (!(max_x < x)) continue;
            max_x = x;
        }
        double length = max_x - min_x;
        for (int i = 0; i < n; ++i) {
            double x;
            double r = rng.nextDouble();
            center[i] = x = min_x + r * length;
        }
    }

    void setCenters(int n, double[] center) {
        if (1 > n || n > 6) {
            String msg = "Number of Gaussian components (" + n + ") not in [1, " + 6 + "].";
            throw new IllegalArgumentException(msg);
        }
        this.n = n;
        System.arraycopy(center, 0, this.mean, 0, n);
    }

    void setSamples(int ns, double[] sample) {
        int min_sample_size = this.n * 32;
        if (ns < min_sample_size) {
            String msg = "Insufficient sample size (" + ns + " < " + min_sample_size + ").";
            throw new IllegalArgumentException(msg);
        }
        this.ns = ns;
        this.sample = sample;
    }

    void initEM() {
        Arrays.sort(this.sample, 0, this.ns);
        Arrays.sort(this.mean, 0, this.n);
        this.maximization();
    }

    void expectation() {
        int i = 0;
        int j = 1;
        block0: do {
            int bi = this.bracket[i];
            while (j < this.n) {
                int bj = this.bracket[j];
                if (bi < bj) {
                    this.bracket[i + 1] = bj;
                    ++i;
                    ++j;
                    continue block0;
                }
                ++j;
            }
        } while (j < this.n);
        this.n = i + 1;
        for (i = 0; i < this.n; ++i) {
            double v;
            double m;
            int ini = this.bracket[i];
            int lim = this.bracket[i + 1];
            int nb = lim - ini;
            double sum = 0.0;
            for (int j2 = ini; j2 < lim; ++j2) {
                double x = this.sample[j2];
                sum += x;
            }
            this.mean[i] = m = sum / (double)nb;
            sum = 0.0;
            for (int j3 = ini; j3 < lim; ++j3) {
                double x = this.sample[j3];
                double d = x - m;
                sum += d * d;
            }
            this.var[i] = v = nb > 1 ? sum / (double)(nb - 1) : 0.0;
        }
    }

    void maximization() {
        this.bracket[0] = 0;
        for (int i = 1; i < this.n; ++i) {
            double mlo = this.mean[i - 1];
            double mhi = this.mean[i];
            int lo = this.bracket[i - 1];
            int hi = this.ns;
            while (lo < hi - 1) {
                double dhi;
                int mid = lo + hi >> 1;
                double sam = this.sample[mid];
                double dlo = Math.abs(sam - mlo);
                if (dlo < (dhi = Math.abs(mhi - sam))) {
                    lo = mid;
                    continue;
                }
                hi = mid;
            }
            this.bracket[i] = hi;
        }
        this.bracket[this.n] = this.ns;
    }

    double measure() {
        double sum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            int ini = this.bracket[i];
            int lim = this.bracket[i + 1];
            int nb = lim - ini;
            double v = this.var[i];
            sum += v * (double)(nb - 1);
        }
        return sum /= (double)this.ns;
    }

    void computeWeights() {
        for (int i = 0; i < this.n; ++i) {
            double wt;
            int ini = this.bracket[i];
            int lim = this.bracket[i + 1];
            int siz = lim - ini;
            this.weight[i] = wt = this.ns > 0 ? (double)siz / (double)this.ns : 0.0;
        }
    }

    void printMog(String label, int n, double[] weight, double[] mean, double[] var) {
        BaseTestCase.println(label + ": n = " + n);
        for (int i = 0; i < n; ++i) {
            BaseTestCase.println("(w, m, v) = (" + weight[i] + ", " + mean[i] + ", " + var[i] + ")");
        }
    }
}

