/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.VarOptCommonImpl;
import org.apache.datasketches.sampling.VarOptItemsUnion;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.Algebraic;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class VarOptUnion
extends AccumulatorEvalFunc<DataByteArray>
implements Algebraic {
    private static final ArrayOfTuplesSerDe SERDE = new ArrayOfTuplesSerDe();
    private final int maxK_;
    private VarOptItemsUnion<Tuple> union_;

    public VarOptUnion(String kStr) {
        this.maxK_ = Integer.parseInt(kStr);
        if (this.maxK_ < 1) {
            throw new IllegalArgumentException("VarOptUnion requires max sample size >= 1: " + this.maxK_);
        }
    }

    VarOptUnion() {
        this.maxK_ = 1024;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
            return;
        }
        DataBag sketches = (DataBag)inputTuple.get(0);
        if (this.union_ == null) {
            this.union_ = VarOptItemsUnion.newInstance((int)this.maxK_);
        }
        for (Tuple t : sketches) {
            DataByteArray dba = (DataByteArray)t.get(0);
            Memory sketch = Memory.wrap((byte[])dba.get());
            this.union_.update(sketch, (ArrayOfItemsSerDe)SERDE);
        }
    }

    public DataByteArray getValue() {
        return this.union_ == null ? null : new DataByteArray(this.union_.getResult().toByteArray((ArrayOfItemsSerDe)SERDE));
    }

    public void cleanup() {
        this.union_ = null;
    }

    public String getInitial() {
        return VarOptCommonImpl.UnionSketchesAsTuple.class.getName();
    }

    public String getIntermed() {
        return VarOptCommonImpl.UnionSketchesAsTuple.class.getName();
    }

    public String getFinal() {
        return VarOptCommonImpl.UnionSketchesAsByteArray.class.getName();
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 50));
    }
}

