/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import java.util.List;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.GetVarOptSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetVarOptSamplesTest {
    private static final ArrayOfTuplesSerDe serDe_ = new ArrayOfTuplesSerDe();

    @Test
    public void checkDegenerateInput() {
        GetVarOptSamples udf = new GetVarOptSamples();
        try {
            Assert.assertNull((Object)udf.exec(null));
            Assert.assertNull((Object)udf.exec(TupleFactory.getInstance().newTuple(0)));
            Assert.assertNull((Object)udf.exec(TupleFactory.getInstance().newTuple(null)));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
    }

    @Test
    public void checkExec() {
        int k = 10;
        int n = 25;
        GetVarOptSamples udf = new GetVarOptSamples();
        try {
            VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)10);
            double cumWt = 0.0;
            for (int i = 1; i <= 25; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple(2);
                double wt = 1.0 * (double)i;
                t.set(0, (Object)wt);
                t.set(1, (Object)i);
                vis.update((Object)t, wt);
                cumWt += wt;
            }
            DataByteArray dba = new DataByteArray(vis.toByteArray((ArrayOfItemsSerDe)serDe_));
            Tuple inputTuple = TupleFactory.getInstance().newTuple((Object)dba);
            DataBag result = udf.exec(inputTuple);
            double cumResultWt = 0.0;
            for (Tuple sample : result) {
                cumResultWt += ((Double)sample.get(0)).doubleValue();
                Tuple record = (Tuple)sample.get(1);
                int id = (Integer)record.get(1);
                Assert.assertTrue((id >= 1 && id <= 25 ? 1 : 0) != 0);
            }
            Assert.assertEquals((double)cumResultWt, (double)cumWt, (double)1.0E-10);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException" + e.getMessage()));
        }
    }

    @Test
    public void validOutputSchemaTest() {
        GetVarOptSamples udf = new GetVarOptSamples();
        try {
            Schema serializedSketch = new Schema();
            serializedSketch.add(new Schema.FieldSchema("field1", 50));
            Schema output = udf.outputSchema(serializedSketch);
            Assert.assertEquals((int)output.size(), (int)1);
            Assert.assertEquals((byte)output.getField((int)0).type, (byte)120);
            List outputFields = output.getField((int)0).schema.getFields();
            Assert.assertEquals((int)outputFields.size(), (int)2);
            Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)0)).alias, (String)"vo_weight");
            Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)0)).type, (byte)25);
            Assert.assertEquals((String)((Schema.FieldSchema)outputFields.get((int)1)).alias, (String)"record");
            Assert.assertEquals((byte)((Schema.FieldSchema)outputFields.get((int)1)).type, (byte)110);
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IOException: " + e.getMessage()));
        }
    }

    @Test
    public void badOutputSchemaTest() {
        GetVarOptSamples udf = new GetVarOptSamples();
        try {
            udf.outputSchema(null);
            Assert.fail((String)"Accepted null schema");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            udf.outputSchema(new Schema());
            Assert.fail((String)"Accepted empty schema");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Schema wrongSchema = new Schema();
            wrongSchema.add(new Schema.FieldSchema("field", 5));
            udf.outputSchema(wrongSchema);
            Assert.fail((String)"Accepted schema with no DataByteArray");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

