/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.pig.kll.GetK;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetKTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void defalutK() throws Exception {
        GetK func = new GetK();
        KllFloatsSketch sketch = new KllFloatsSketch();
        Integer result = (Integer)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)200);
    }

    @Test
    public void customK() throws Exception {
        GetK func = new GetK();
        KllFloatsSketch sketch = new KllFloatsSketch(400);
        Integer result = (Integer)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)400);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void noInputs() throws Exception {
        GetK func = new GetK();
        func.exec(TUPLE_FACTORY.newTuple());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooManyInputs() throws Exception {
        GetK func = new GetK();
        func.exec(TUPLE_FACTORY.newTuple(2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetK func = new GetK();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0)));
    }
}

