/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CommonMemoryTest {
    private final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkSetGet() throws Exception {
        int memCapacity = 16;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            Assert.assertEquals((long)mem.getCapacity(), (long)memCapacity);
            CommonMemoryTest.setGetTests(mem);
        }
    }

    public static void setGetTests(WritableMemory mem) {
        mem.putBoolean(0L, true);
        Assert.assertTrue((boolean)mem.getBoolean(0L));
        mem.putBoolean(0L, false);
        Assert.assertFalse((boolean)mem.getBoolean(0L));
        mem.putByte(0L, (byte)-1);
        Assert.assertEquals((byte)mem.getByte(0L), (byte)-1);
        mem.putByte(0L, (byte)0);
        Assert.assertEquals((byte)mem.getByte(0L), (byte)0);
        mem.putChar(0L, 'A');
        Assert.assertEquals((char)mem.getChar(0L), (char)'A');
        mem.putChar(0L, 'Z');
        Assert.assertEquals((char)mem.getChar(0L), (char)'Z');
        mem.putShort(0L, (short)Short.MAX_VALUE);
        Assert.assertEquals((short)mem.getShort(0L), (short)Short.MAX_VALUE);
        mem.putShort(0L, (short)Short.MIN_VALUE);
        Assert.assertEquals((short)mem.getShort(0L), (short)Short.MIN_VALUE);
        mem.putInt(0L, Integer.MAX_VALUE);
        Assert.assertEquals((int)mem.getInt(0L), (int)Integer.MAX_VALUE);
        mem.putInt(0L, Integer.MIN_VALUE);
        Assert.assertEquals((int)mem.getInt(0L), (int)Integer.MIN_VALUE);
        mem.putFloat(0L, Float.MAX_VALUE);
        Assert.assertEquals((float)mem.getFloat(0L), (float)Float.MAX_VALUE);
        mem.putFloat(0L, Float.MIN_VALUE);
        Assert.assertEquals((float)mem.getFloat(0L), (float)Float.MIN_VALUE);
        mem.putLong(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)mem.getLong(0L), (long)Long.MAX_VALUE);
        mem.putLong(0L, Long.MIN_VALUE);
        Assert.assertEquals((long)mem.getLong(0L), (long)Long.MIN_VALUE);
        mem.putDouble(0L, Double.MAX_VALUE);
        Assert.assertEquals((double)mem.getDouble(0L), (double)Double.MAX_VALUE);
        mem.putDouble(0L, Double.MIN_VALUE);
        Assert.assertEquals((double)mem.getDouble(0L), (double)Double.MIN_VALUE);
    }

    @Test
    public void checkSetGetArrays() throws Exception {
        int memCapacity = 32;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            Assert.assertEquals((long)memCapacity, (long)mem.getCapacity());
            CommonMemoryTest.setGetArraysTests(mem);
        }
    }

    public static void setGetArraysTests(WritableMemory mem) {
        int words = 4;
        byte[] srcArray2 = new byte[]{1, -2, 3, -4};
        byte[] dstArray2 = new byte[4];
        mem.putByteArray(0L, srcArray2, 0, words);
        mem.getByteArray(0L, dstArray2, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((byte)dstArray2[i], (byte)srcArray2[i]);
        }
        char[] srcArray3 = new char[]{'A', 'B', 'C', 'D'};
        char[] dstArray3 = new char[words];
        mem.putCharArray(0L, srcArray3, 0, words);
        mem.getCharArray(0L, dstArray3, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((char)dstArray3[i], (char)srcArray3[i]);
        }
        double[] srcArray4 = new double[]{1.0, -2.0, 3.0, -4.0};
        double[] dstArray4 = new double[words];
        mem.putDoubleArray(0L, srcArray4, 0, words);
        mem.getDoubleArray(0L, dstArray4, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((double)dstArray4[i], (double)srcArray4[i], (double)0.0);
        }
        float[] srcArray5 = new float[]{1.0f, -2.0f, 3.0f, -4.0f};
        float[] dstArray5 = new float[words];
        mem.putFloatArray(0L, srcArray5, 0, words);
        mem.getFloatArray(0L, dstArray5, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((double)dstArray5[i], (double)srcArray5[i], (double)0.0);
        }
        int[] srcArray6 = new int[]{1, -2, 3, -4};
        int[] dstArray6 = new int[words];
        mem.putIntArray(0L, srcArray6, 0, words);
        mem.getIntArray(0L, dstArray6, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((int)dstArray6[i], (int)srcArray6[i]);
        }
        long[] srcArray7 = new long[]{1L, -2L, 3L, -4L};
        long[] dstArray7 = new long[words];
        mem.putLongArray(0L, srcArray7, 0, words);
        mem.getLongArray(0L, dstArray7, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((long)dstArray7[i], (long)srcArray7[i]);
        }
        short[] srcArray8 = new short[]{1, -2, 3, -4};
        short[] dstArray8 = new short[words];
        mem.putShortArray(0L, srcArray8, 0, words);
        mem.getShortArray(0L, dstArray8, 0, words);
        for (int i = 0; i < words; ++i) {
            Assert.assertEquals((short)dstArray8[i], (short)srcArray8[i]);
        }
    }

    @Test
    public void checkSetGetPartialArraysWithOffset() throws Exception {
        int memCapacity = 32;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            Assert.assertEquals((long)memCapacity, (long)mem.getCapacity());
            CommonMemoryTest.setGetPartialArraysWithOffsetTests(mem);
        }
    }

    public static void setGetPartialArraysWithOffsetTests(WritableMemory mem) {
        int items = 4;
        byte[] srcArray2 = new byte[]{1, -2, 3, -4};
        byte[] dstArray2 = new byte[items];
        mem.putByteArray(0L, srcArray2, 2, items / 2);
        mem.getByteArray(0L, dstArray2, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((byte)dstArray2[i], (byte)srcArray2[i]);
        }
        char[] srcArray3 = new char[]{'A', 'B', 'C', 'D'};
        char[] dstArray3 = new char[items];
        mem.putCharArray(0L, srcArray3, 2, items / 2);
        mem.getCharArray(0L, dstArray3, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((char)dstArray3[i], (char)srcArray3[i]);
        }
        double[] srcArray4 = new double[]{1.0, -2.0, 3.0, -4.0};
        double[] dstArray4 = new double[items];
        mem.putDoubleArray(0L, srcArray4, 2, items / 2);
        mem.getDoubleArray(0L, dstArray4, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((double)dstArray4[i], (double)srcArray4[i], (double)0.0);
        }
        float[] srcArray5 = new float[]{1.0f, -2.0f, 3.0f, -4.0f};
        float[] dstArray5 = new float[items];
        mem.putFloatArray(0L, srcArray5, 2, items / 2);
        mem.getFloatArray(0L, dstArray5, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((double)dstArray5[i], (double)srcArray5[i], (double)0.0);
        }
        int[] srcArray6 = new int[]{1, -2, 3, -4};
        int[] dstArray6 = new int[items];
        mem.putIntArray(0L, srcArray6, 2, items / 2);
        mem.getIntArray(0L, dstArray6, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((int)dstArray6[i], (int)srcArray6[i]);
        }
        long[] srcArray7 = new long[]{1L, -2L, 3L, -4L};
        long[] dstArray7 = new long[items];
        mem.putLongArray(0L, srcArray7, 2, items / 2);
        mem.getLongArray(0L, dstArray7, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((long)dstArray7[i], (long)srcArray7[i]);
        }
        short[] srcArray8 = new short[]{1, -2, 3, -4};
        short[] dstArray8 = new short[items];
        mem.putShortArray(0L, srcArray8, 2, items / 2);
        mem.getShortArray(0L, dstArray8, 2, items / 2);
        for (int i = 2; i < items; ++i) {
            Assert.assertEquals((short)dstArray8[i], (short)srcArray8[i]);
        }
    }

    @Test
    public void checkSetClearIsBits() throws Exception {
        int memCapacity = 8;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            Assert.assertEquals((long)memCapacity, (long)mem.getCapacity());
            mem.clear();
            CommonMemoryTest.setClearIsBitsTests(mem);
        }
    }

    public static void setClearIsBitsTests(WritableMemory mem) {
        int i;
        for (i = 0; i < 8; ++i) {
            long bitMask = 1 << i;
            long v = (long)mem.getByte(0L) & 0xFFL;
            Assert.assertTrue((boolean)Util.isAnyBitsClear((long)v, (long)bitMask));
            mem.setBits(0L, (byte)bitMask);
            v = (long)mem.getByte(0L) & 0xFFL;
            Assert.assertTrue((boolean)Util.isAnyBitsSet((long)v, (long)bitMask));
            mem.clearBits(0L, (byte)bitMask);
            v = (long)mem.getByte(0L) & 0xFFL;
            Assert.assertTrue((boolean)Util.isAnyBitsClear((long)v, (long)bitMask));
        }
        for (i = 0; i < 7; ++i) {
            long bitMask1 = 1 << i;
            long bitMask2 = 3 << i;
            long v = (long)mem.getByte(0L) & 0xFFL;
            Assert.assertTrue((boolean)Util.isAnyBitsClear((long)v, (long)bitMask1));
            Assert.assertTrue((boolean)Util.isAnyBitsClear((long)v, (long)bitMask2));
            mem.setBits(0L, (byte)bitMask1);
            v = (long)mem.getByte(0L) & 0xFFL;
            Assert.assertTrue((boolean)Util.isAnyBitsSet((long)v, (long)bitMask2));
            Assert.assertTrue((boolean)Util.isAnyBitsClear((long)v, (long)bitMask2));
            Assert.assertFalse((boolean)Util.isAllBitsSet((long)v, (long)bitMask2));
            Assert.assertFalse((boolean)Util.isAllBitsClear((long)v, (long)bitMask2));
        }
    }

    @Test
    public void checkSetClearMemoryRegions() throws Exception {
        int memCapacity = 64;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            CommonMemoryTest.setClearMemoryRegionsTests(mem);
            for (int i = 0; i < memCapacity; ++i) {
                Assert.assertEquals((int)mem.getByte((long)i), (int)0);
            }
        }
    }

    public static void setClearMemoryRegionsTests(WritableMemory mem) {
        int i;
        int i2;
        int accessCapacity = (int)mem.getCapacity();
        int reg1Start = 0;
        int reg1Len = 28;
        int reg2Start = 28;
        int reg2Len = 32;
        byte b1 = 5;
        mem.fill((long)reg1Start, (long)reg1Len, b1);
        for (int i3 = reg1Start; i3 < reg1Len + reg1Start; ++i3) {
            Assert.assertEquals((byte)mem.getByte((long)i3), (byte)b1);
        }
        byte b2 = 7;
        mem.fill((long)reg2Start, (long)reg2Len, b2);
        for (int i4 = reg2Start; i4 < reg2Len + reg2Start; ++i4) {
            Assert.assertEquals((byte)mem.getByte((long)i4), (byte)b2);
        }
        byte zeroByte = 0;
        mem.clear((long)reg1Start, (long)reg1Len);
        for (i2 = reg1Start; i2 < reg1Len + reg1Start; ++i2) {
            Assert.assertEquals((byte)mem.getByte((long)i2), (byte)zeroByte);
        }
        mem.clear((long)reg2Start, (long)reg2Len);
        for (i2 = reg2Start; i2 < reg2Len + reg2Start; ++i2) {
            Assert.assertEquals((byte)mem.getByte((long)i2), (byte)zeroByte);
        }
        byte b4 = 127;
        mem.fill(b4);
        for (i = 0; i < accessCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)b4);
        }
        mem.clear();
        for (i = 0; i < accessCapacity; ++i) {
            Assert.assertEquals((byte)mem.getByte((long)i), (byte)zeroByte);
        }
    }

    @Test
    public void checkToHexStringAllMem() throws Exception {
        int memCapacity = 48;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory mem = WritableMemory.allocateDirect((long)memCapacity, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr);
            CommonMemoryTest.toHexStringAllMemTests(mem);
        }
    }

    public static void toHexStringAllMemTests(WritableMemory mem) {
        int memCapacity = (int)mem.getCapacity();
        for (int i = 0; i < memCapacity; ++i) {
            mem.putByte((long)i, (byte)i);
        }
    }

    @Test
    public void printlnTest() {
        CommonMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

