/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.hash.XxHash;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.apache.datasketches.tuple.Summary;

public final class Util {
    private static final int PRIME = 2050804337;

    public static final long[] doubleToLongArray(double value) {
        double d = value == 0.0 ? 0.0 : value;
        long[] array = new long[]{Double.doubleToLongBits(d)};
        return array;
    }

    public static final byte[] stringToByteArray(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static int getStartingCapacity(int nomEntries, int lgResizeFactor) {
        return 1 << ThetaUtil.startingSubMultiple(Integer.numberOfTrailingZeros(org.apache.datasketches.common.Util.ceilingPowerOf2(nomEntries) * 2), lgResizeFactor, 5);
    }

    public static String stringConcat(String[] strArr) {
        int len = strArr.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(strArr[i]);
            if (i + 1 >= len) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static long stringHash(String s) {
        return XxHash.hashString(s, 0, s.length(), 2050804337L);
    }

    public static long stringArrHash(String[] strArray) {
        String s = Util.stringConcat(strArray);
        return XxHash.hashCharArr(s.toCharArray(), 0, s.length(), 2050804337L);
    }

    public static <S extends Summary> S[] copySummaryArray(S[] summaryArr) {
        int len = summaryArr.length;
        Summary[] tmpSummaryArr = Util.newSummaryArray(summaryArr, (int)len);
        for (int i = 0; i < len; ++i) {
            S summary = summaryArr[i];
            if (summary == null) continue;
            tmpSummaryArr[i] = summary.copy();
        }
        return tmpSummaryArr;
    }

    public static <S extends Summary> S[] newSummaryArray(S[] summaryArr, int length) {
        Class<?> summaryType = summaryArr.getClass().getComponentType();
        Summary[] tmpSummaryArr = (Summary[])Array.newInstance(summaryType, length);
        return tmpSummaryArr;
    }
}

