/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemorySegmentHashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdateReturnState;

class DirectQuickSelectSketchR
extends UpdatableThetaSketch {
    MemorySegment wseg_;

    DirectQuickSelectSketchR(MemorySegment wseg, long seed) {
        Objects.requireNonNull(wseg, "MemorySegment wseg must not be null");
        super(seed);
        this.wseg_ = wseg;
    }

    private DirectQuickSelectSketchR(long seed, MemorySegment srcSeg) {
        Objects.requireNonNull(srcSeg, "MemorySegment srcSeg must not be null");
        super(seed);
        this.wseg_ = srcSeg.asReadOnly();
    }

    static DirectQuickSelectSketchR readOnlyWrap(MemorySegment srcSeg, long seed) {
        int preambleLongs = PreambleUtil.checkSegPreambleCap(srcSeg);
        int lgNomLongs = PreambleUtil.extractLgNomLongs(srcSeg);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(srcSeg);
        DirectQuickSelectSketchR.checkSegIntegrity(srcSeg, seed, preambleLongs, lgNomLongs, lgArrLongs);
        UpdatableThetaSketch.checkUnionAndQuickSelectFamily(srcSeg, preambleLongs, lgNomLongs);
        return new DirectQuickSelectSketchR(seed, srcSeg);
    }

    static DirectQuickSelectSketchR fastReadOnlyWrap(MemorySegment srcSeg, long seed) {
        return new DirectQuickSelectSketchR(seed, srcSeg);
    }

    @Override
    public int getCurrentBytes() {
        int lgArrLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 4L) & 0xFF;
        int preLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F;
        return preLongs + (1 << lgArrLongs) << 3;
    }

    @Override
    public double getEstimate() {
        int curCount = PreambleUtil.extractCurCount(this.wseg_);
        long thetaLong = PreambleUtil.extractThetaLong(this.wseg_);
        return ThetaSketch.estimate(thetaLong, curCount);
    }

    @Override
    public Family getFamily() {
        int familyID = this.wseg_.get(ValueLayout.JAVA_BYTE, 2L) & 0xFF;
        return Family.idToFamily(familyID);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.wseg_.get(ValueLayout.JAVA_INT_UNALIGNED, 8L);
    }

    @Override
    public long getThetaLong() {
        return this.isEmpty() ? Long.MAX_VALUE : this.wseg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.wseg_ != null && this.wseg_.scope().isAlive();
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.wseg_.isNative();
    }

    @Override
    public boolean isEmpty() {
        return PreambleUtil.isEmptyFlag(this.wseg_);
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this.hasMemorySegment() && MemorySegmentStatus.isSameResource(this.wseg_, that);
    }

    @Override
    public HashIterator iterator() {
        return new MemorySegmentHashIterator(this.wseg_, 1 << this.getLgArrLongs(), this.getThetaLong());
    }

    @Override
    public byte[] toByteArray() {
        int curCount = PreambleUtil.extractCurCount(this.wseg_);
        CompactOperations.checkIllegalCurCountAndEmpty(this.isEmpty(), curCount);
        int lengthBytes = this.getCurrentBytes();
        byte[] byteArray = new byte[lengthBytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        MemorySegment.copy(this.wseg_, 0L, seg, 0L, lengthBytes);
        long thetaLong = CompactOperations.correctThetaOnCompact(this.isEmpty(), curCount, PreambleUtil.extractThetaLong(this.wseg_));
        PreambleUtil.insertThetaLong(seg, thetaLong);
        return byteArray;
    }

    @Override
    public final int getLgNomLongs() {
        return PreambleUtil.extractLgNomLongs(this.wseg_);
    }

    @Override
    float getP() {
        return this.wseg_.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 12L);
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.getLgRF());
    }

    @Override
    public UpdatableThetaSketch rebuild() {
        throw new SketchesReadOnlyException();
    }

    @Override
    public void reset() {
        throw new SketchesReadOnlyException();
    }

    @Override
    long[] getCache() {
        long lgArrLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 4L) & 0xFF;
        int preambleLongs = this.wseg_.get(ValueLayout.JAVA_BYTE, 0L) & 0x3F;
        long[] cacheArr = new long[1 << (int)lgArrLongs];
        MemorySegment.copy(this.wseg_, ValueLayout.JAVA_LONG_UNALIGNED, preambleLongs << 3, cacheArr, 0, 1 << (int)lgArrLongs);
        return cacheArr;
    }

    @Override
    int getCompactPreambleLongs() {
        return CompactOperations.computeCompactPreLongs(this.isEmpty(), this.getRetainedEntries(true), this.getThetaLong());
    }

    @Override
    int getCurrentPreambleLongs() {
        return ThetaSketch.getPreambleLongs(this.wseg_);
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.wseg_;
    }

    @Override
    short getSeedHash() {
        return (short)PreambleUtil.extractSeedHash(this.wseg_);
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    boolean isOutOfSpace(int numEntries) {
        return false;
    }

    @Override
    int getLgArrLongs() {
        return this.wseg_.get(ValueLayout.JAVA_BYTE, 4L) & 0xFF;
    }

    int getLgRF() {
        return this.wseg_.get(ValueLayout.JAVA_BYTE, 0L) >>> 6 & 3;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        throw new SketchesReadOnlyException();
    }
}

