/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.partitions;

import java.util.List;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.partitions.Partitioner;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public class PartitionResults {
    private static final String LS = System.getProperty("line.separator");
    private static final String[] hdr = new String[]{"Level.Part", "Partition", "LowerBound", "UpperBound", "ApproxNumItems", "Include Rule"};
    private static final String hdrFmt = "%15s %10s %15s %15s %15s %15s\n";
    private static final String dFmt = "%15s %10d %15s %15s %15d %15s\n";
    private static final boolean enablePrinting = true;

    public static void output(String sketchType, List<Partitioner.PartitionBoundsRow<String>> list, int k, QuantileSearchCriteria searchCrit, long totalN, long tgtPartitionSize, int maxPartsPerSk, long fillInitialSketchTime_mS, long partitioningTime_mS, long totalTime_mS) {
        PartitionResults.printf(hdrFmt, hdr);
        int numParts = list.size();
        double meanPartSize = (double)totalN / (double)numParts;
        double size = 0.0;
        double sumSizes = 0.0;
        double sumAbsRelErr = 0.0;
        double sumSqErr = 0.0;
        double maxAbsErr = 0.0;
        for (int i = 0; i < numParts; ++i) {
            Partitioner.PartitionBoundsRow<String> row = list.get(i);
            PartitionResults.printf(dFmt, row.levelPartId, i + 1, row.lowerBound, row.upperBound, row.approxNumDeltaItems, row.rule.name());
            size = row.approxNumDeltaItems;
            sumSizes += size;
            sumAbsRelErr += Math.abs(size / meanPartSize - 1.0);
            double absErr = Math.abs(size - meanPartSize);
            sumSqErr += absErr * absErr;
            maxAbsErr = Math.max(absErr, maxAbsErr);
        }
        double meanAbsRelErr = sumAbsRelErr / (double)numParts;
        double meanSqErr = sumSqErr / (double)numParts;
        double normMeanSqErr = meanSqErr / (meanPartSize * meanPartSize);
        double rmsRelErr = Math.sqrt(normMeanSqErr);
        double maxAbsErrFraction = maxAbsErr / meanPartSize;
        PartitionResults.println(LS + sketchType + " ItemsSketch Partitions Test");
        PartitionResults.println(LS + "INPUT:");
        PartitionResults.printf("Sketch K              :%,20d\n", k);
        PartitionResults.printf("Search Criteria       :%20s\n", searchCrit.name());
        PartitionResults.printf("Total N               :%,20d\n", totalN);
        PartitionResults.printf("Tgt Partition Size    :%,20d\n", tgtPartitionSize);
        PartitionResults.printf("Max Parts Per Sketch  :%20d\n", maxPartsPerSk);
        PartitionResults.println(LS + "STATISTICS:");
        PartitionResults.printf("Total ApproxNumItems  :%,20d\n", (long)sumSizes);
        PartitionResults.printf("Mean Partition Size   :%,20.1f\n", meanPartSize);
        PartitionResults.printf("Mean Abs Rel Error    :%20.3f%%\n", meanAbsRelErr * 100.0);
        PartitionResults.printf("Norm RMS Error        :%20.3f%%\n", rmsRelErr * 100.0);
        PartitionResults.printf("Max Abs Error Percent :%20.3f%%\n", maxAbsErrFraction * 100.0);
        PartitionResults.println(LS + "TIMINGS:");
        PartitionResults.println("FillInitialSketchTime : " + Util.milliSecToString((long)fillInitialSketchTime_mS));
        PartitionResults.println("PartioningTime        : " + Util.milliSecToString((long)partitioningTime_mS));
        PartitionResults.println("Total Time            : " + Util.milliSecToString((long)totalTime_mS) + LS);
    }

    private static final void println(Object o) {
        System.out.println(o.toString());
    }

    private static final void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }
}

