/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.ConcurrentDirectQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.HeapAlphaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;

public class UpdateSketchBuilder {
    private int bLgNomLongs = Integer.numberOfTrailingZeros(4096);
    private long bSeed = 9001L;
    private ResizeFactor bRF = ResizeFactor.X8;
    private Family bFam = Family.QUICKSELECT;
    private float bP = 1.0f;
    private MemoryRequestServer bMemReqSvr = new DefaultMemoryRequestServer();
    private int bNumPoolThreads = ConcurrentPropagationService.NUM_POOL_THREADS;
    private int bLocalLgNomLongs = 4;
    private boolean bPropagateOrderedCompact = true;
    private double bMaxConcurrencyError = 0.0;
    private int bMaxNumLocalThreads = 1;

    public UpdateSketchBuilder setNominalEntries(int nomEntries) {
        this.bLgNomLongs = ThetaUtil.checkNomLongs(nomEntries);
        return this;
    }

    public UpdateSketchBuilder setLogNominalEntries(int lgNomEntries) {
        this.bLgNomLongs = ThetaUtil.checkNomLongs(1 << lgNomEntries);
        return this;
    }

    public int getLgNominalEntries() {
        return this.bLgNomLongs;
    }

    public UpdateSketchBuilder setLocalNominalEntries(int nomEntries) {
        this.bLocalLgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomEntries));
        if (this.bLocalLgNomLongs > 26 || this.bLocalLgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomEntries);
        }
        return this;
    }

    public UpdateSketchBuilder setLocalLogNominalEntries(int lgNomEntries) {
        this.bLocalLgNomLongs = lgNomEntries;
        if (this.bLocalLgNomLongs > 26 || this.bLocalLgNomLongs < 4) {
            throw new SketchesArgumentException("Log Nominal Entries must be >= 4 and <= 26: " + lgNomEntries);
        }
        return this;
    }

    public int getLocalLgNominalEntries() {
        return this.bLocalLgNomLongs;
    }

    public UpdateSketchBuilder setSeed(long seed) {
        this.bSeed = seed;
        return this;
    }

    public long getSeed() {
        return this.bSeed;
    }

    public UpdateSketchBuilder setP(float p) {
        if ((double)p <= 0.0 || (double)p > 1.0) {
            throw new SketchesArgumentException("p must be > 0 and <= 1.0: " + p);
        }
        this.bP = p;
        return this;
    }

    public float getP() {
        return this.bP;
    }

    public UpdateSketchBuilder setResizeFactor(ResizeFactor rf) {
        this.bRF = rf;
        return this;
    }

    public ResizeFactor getResizeFactor() {
        return this.bRF;
    }

    public UpdateSketchBuilder setFamily(Family family) {
        this.bFam = family;
        return this;
    }

    public Family getFamily() {
        return this.bFam;
    }

    public UpdateSketchBuilder setMemoryRequestServer(MemoryRequestServer memReqSvr) {
        this.bMemReqSvr = memReqSvr;
        return this;
    }

    public MemoryRequestServer getMemoryRequestServer() {
        return this.bMemReqSvr;
    }

    public void setNumPoolThreads(int numPoolThreads) {
        this.bNumPoolThreads = numPoolThreads;
    }

    public int getNumPoolThreads() {
        return this.bNumPoolThreads;
    }

    public UpdateSketchBuilder setPropagateOrderedCompact(boolean prop) {
        this.bPropagateOrderedCompact = prop;
        return this;
    }

    public boolean getPropagateOrderedCompact() {
        return this.bPropagateOrderedCompact;
    }

    public void setMaxConcurrencyError(double maxConcurrencyError) {
        this.bMaxConcurrencyError = maxConcurrencyError;
    }

    public double getMaxConcurrencyError() {
        return this.bMaxConcurrencyError;
    }

    public void setMaxNumLocalThreads(int maxNumLocalThreads) {
        this.bMaxNumLocalThreads = maxNumLocalThreads;
    }

    public int getMaxNumLocalThreads() {
        return this.bMaxNumLocalThreads;
    }

    public UpdateSketch build() {
        return this.build(null);
    }

    public UpdateSketch build(WritableMemory dstMem) {
        UpdateSketch sketch = null;
        switch (this.bFam) {
            case ALPHA: {
                if (dstMem == null) {
                    sketch = HeapAlphaSketch.newHeapInstance(this.bLgNomLongs, this.bSeed, this.bP, this.bRF);
                    break;
                }
                throw new SketchesArgumentException("AlphaSketch cannot be made Direct to Memory.");
            }
            case QUICKSELECT: {
                if (dstMem == null) {
                    sketch = new HeapQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, false);
                    break;
                }
                sketch = new DirectQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bP, this.bRF, this.bMemReqSvr, dstMem, false);
                break;
            }
            default: {
                throw new SketchesArgumentException("Given Family cannot be built as a Theta Sketch: " + this.bFam.toString());
            }
        }
        return sketch;
    }

    public UpdateSketch buildShared() {
        return this.buildShared(null);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Harmless in Builder, fix later")
    public UpdateSketch buildShared(WritableMemory dstMem) {
        ConcurrentPropagationService.NUM_POOL_THREADS = this.bNumPoolThreads;
        if (dstMem == null) {
            return new ConcurrentHeapQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bMaxConcurrencyError);
        }
        return new ConcurrentDirectQuickSelectSketch(this.bLgNomLongs, this.bSeed, this.bMaxConcurrencyError, dstMem);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Harmless in Builder, fix later")
    public UpdateSketch buildSharedFromSketch(UpdateSketch sketch, WritableMemory dstMem) {
        ConcurrentPropagationService.NUM_POOL_THREADS = this.bNumPoolThreads;
        if (dstMem == null) {
            return new ConcurrentHeapQuickSelectSketch(sketch, this.bSeed, this.bMaxConcurrencyError);
        }
        return new ConcurrentDirectQuickSelectSketch(sketch, this.bSeed, this.bMaxConcurrencyError, dstMem);
    }

    public UpdateSketch buildLocal(UpdateSketch shared) {
        if (shared == null || !(shared instanceof ConcurrentSharedThetaSketch)) {
            throw new SketchesStateException("The concurrent shared sketch must be built first.");
        }
        return new ConcurrentHeapThetaBuffer(this.bLocalLgNomLongs, this.bSeed, (ConcurrentSharedThetaSketch)((Object)shared), this.bPropagateOrderedCompact, this.bMaxNumLocalThreads);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSketchBuilder configuration:").append(Util.LS);
        sb.append("LgK:").append('\t').append(this.bLgNomLongs).append(Util.LS);
        sb.append("K:").append('\t').append(1 << this.bLgNomLongs).append(Util.LS);
        sb.append("LgLocalK:").append('\t').append(this.bLocalLgNomLongs).append(Util.LS);
        sb.append("LocalK:").append('\t').append(1 << this.bLocalLgNomLongs).append(Util.LS);
        sb.append("Seed:").append('\t').append(this.bSeed).append(Util.LS);
        sb.append("p:").append('\t').append(this.bP).append(Util.LS);
        sb.append("ResizeFactor:").append('\t').append((Object)this.bRF).append(Util.LS);
        sb.append("Family:").append('\t').append((Object)this.bFam).append(Util.LS);
        String mrsStr = this.bMemReqSvr.getClass().getSimpleName();
        sb.append("MemoryRequestServer:").append('\t').append(mrsStr).append(Util.LS);
        sb.append("Propagate Ordered Compact").append('\t').append(this.bPropagateOrderedCompact).append(Util.LS);
        sb.append("NumPoolThreads").append('\t').append(this.bNumPoolThreads).append(Util.LS);
        sb.append("MaxConcurrencyError").append('\t').append(this.bMaxConcurrencyError).append(Util.LS);
        sb.append("MaxNumLocalThreads").append('\t').append(this.bMaxNumLocalThreads).append(Util.LS);
        return sb.toString();
    }
}

