/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.List;
import org.apache.datasketches.hive.tuple.DoubleSummarySketchToEstimatesUDF;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoubleSummarySketchToEstimatesUDFTest {
    @Test
    public void nullSketch() {
        List result = new DoubleSummarySketchToEstimatesUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        List result = new DoubleSummarySketchToEstimatesUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.0);
    }

    @Test
    public void normalCase() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2L, (Object)1.0);
        List result = new DoubleSummarySketchToEstimatesUDF().evaluate(new BytesWritable(sketch.compact().toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)2);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)2.0);
    }
}

