/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.tomcat;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.core.config.FedizConfigurator;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataDocumentHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.tomcat.handler.TomcatLogoutHandler;
import org.apache.cxf.fediz.tomcat.handler.TomcatSigninHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FederationAuthenticator
extends FormAuthenticator {
    public static final String SESSION_SAVED_REQUEST_PREFIX = "SAVED_REQUEST_";
    public static final String SESSION_SAVED_URI_PREFIX = "SAVED_URI_";
    public static final String FEDERATION_NOTE = "org.apache.cxf.fediz.tomcat.FEDERATION";
    public static final String REQUEST_STATE = "org.apache.cxf.fediz.REQUEST_STATE";
    public static final String SECURITY_TOKEN = "org.apache.fediz.SECURITY_TOKEN";
    protected static final String INFO = "org.apache.cxf.fediz.tomcat.WsFedAuthenticator/1.0";
    protected static final String TRUSTED_ISSUER = "org.apache.cxf.fediz.tomcat.TRUSTED_ISSUER";
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticator.class);
    protected String configFile;
    protected String encoding = "UTF-8";
    private FedizConfigurator configurator;

    public FederationAuthenticator() {
        LOG.debug("WsFedAuthenticator()");
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected synchronized void startInternal() throws LifecycleException {
        try {
            String catalinaBase;
            File f = new File(this.getConfigFile());
            if (!f.exists() && (catalinaBase = System.getProperty("catalina.base")) != null && catalinaBase.length() > 0) {
                f = new File(catalinaBase.concat(File.separator + this.getConfigFile()));
            }
            this.configurator = new FedizConfigurator();
            this.configurator.loadConfig(f);
            LOG.debug("Fediz configuration read from " + f.getAbsolutePath());
        }
        catch (IOException | JAXBException e) {
            throw new LifecycleException("Failed to load Fediz configuration", e);
        }
        super.startInternal();
    }

    protected synchronized void stopInternal() throws LifecycleException {
        List fedContextList;
        if (this.configurator != null && (fedContextList = this.configurator.getFedizContextList()) != null) {
            for (FedizContext fedContext : fedContextList) {
                try {
                    fedContext.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.stopInternal();
    }

    protected synchronized FedizContext getContextConfiguration(String contextName) {
        if (this.configurator == null) {
            throw new IllegalStateException("No Fediz configuration available");
        }
        FedizContext config = this.configurator.getFedizContext(contextName);
        if (config == null) {
            throw new IllegalStateException("No Fediz configuration for context :" + contextName);
        }
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase != null && catalinaBase.length() > 0) {
            config.setRelativePath(catalinaBase);
        }
        return config;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        FedizContext fedConfig;
        MetadataDocumentHandler mdHandler;
        LOG.debug("WsFedAuthenticator:invoke()");
        request.setCharacterEncoding(this.encoding);
        String contextName = request.getServletContext().getContextPath();
        if (contextName == null || contextName.isEmpty()) {
            contextName = "/";
        }
        if ((mdHandler = new MetadataDocumentHandler(fedConfig = this.getContextConfiguration(contextName))).canHandleRequest((HttpServletRequest)request)) {
            mdHandler.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        TomcatLogoutHandler logoutHandler = new TomcatLogoutHandler(fedConfig, contextName, request);
        if (logoutHandler.canHandleRequest((HttpServletRequest)request)) {
            Element token = (Element)request.getSession().getAttribute(SECURITY_TOKEN);
            logoutHandler.setToken(token);
            logoutHandler.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        super.invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        LOG.debug("authenticate invoked");
        String contextName = request.getServletContext().getContextPath();
        if (contextName == null || contextName.isEmpty()) {
            contextName = "/";
        }
        LOG.debug("reading configuration for context path: {}", (Object)contextName);
        FedizContext fedCtx = this.getContextConfiguration(contextName);
        TomcatSigninHandler signinHandler = new TomcatSigninHandler(fedCtx);
        signinHandler.setLandingPage(this.landingPage);
        if (signinHandler.canHandleRequest((HttpServletRequest)request)) {
            FedizPrincipal principal = (FedizPrincipal)signinHandler.handleRequest((HttpServletRequest)request, response);
            if (principal != null) {
                this.register(request, response, (Principal)principal, "WSFED", null, null);
                LOG.debug("Authentication of '{}' was successful", (Object)principal);
                this.resumeRequest(signinHandler.getContextParameter((HttpServletRequest)request), (HttpServletRequest)request, response);
            } else {
                response.sendError(401);
            }
            return false;
        }
        if (this.matchRequest(request)) {
            return this.restoreRequest(request, response);
        }
        if (this.checkUserAuthentication(request, response, fedCtx)) {
            return true;
        }
        LOG.info("No valid principal found in existing session. Redirecting to IDP");
        this.redirectToIdp(request, response, fedCtx);
        return false;
    }

    public boolean doAuthenticate(Request request, HttpServletResponse response) throws IOException {
        return this.authenticate(request, response);
    }

    protected void resumeRequest(String contextId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (contextId == null) {
            LOG.warn("The context parameter has not been provided back with signin request.");
            response.sendError(401);
        } else {
            Session session = ((Request)request).getSessionInternal();
            String originalURL = (String)session.getNote(SESSION_SAVED_URI_PREFIX + contextId);
            session.removeNote(SESSION_SAVED_URI_PREFIX + contextId);
            SavedRequest saved = (SavedRequest)session.getNote(SESSION_SAVED_REQUEST_PREFIX + ((Request)request).getDecodedRequestURI());
            if (saved != null) {
                session.setMaxInactiveInterval(saved.getOriginalMaxInactiveInterval());
                LOG.debug("Session timeout set to {}", (Object)session.getMaxInactiveInterval());
            }
            try {
                if (originalURL != null) {
                    LOG.debug("Restore request to {}", (Object)originalURL);
                    response.sendRedirect(response.encodeRedirectURL(originalURL));
                } else {
                    LOG.debug("User took so long to log on the session expired");
                    if (this.landingPage == null) {
                        response.sendError(408, sm.getString("authenticator.sessionExpired"));
                    } else {
                        String uri = request.getContextPath() + this.landingPage;
                        response.sendRedirect(response.encodeRedirectURL(uri));
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Cannot resume with request. {}", (Object)e.getMessage());
            }
        }
    }

    protected boolean restoreRequest(Request request, HttpServletResponse response) throws IOException {
        Session session = request.getSessionInternal();
        LOG.debug("Restore request from session '{}'", (Object)session.getIdInternal());
        if (this.restoreRequest(request)) {
            LOG.debug("Proceed to restored request");
            return true;
        }
        LOG.warn("Restore of original request failed");
        response.sendError(400);
        return false;
    }

    protected void redirectToIdp(Request request, HttpServletResponse response, FedizContext fedCtx) throws IOException {
        block7: {
            FedizProcessor processor = FedizProcessorFactory.newFedizProcessor((Protocol)fedCtx.getProtocol());
            try {
                RedirectionResponse redirectionResponse = processor.createSignInRequest((HttpServletRequest)request, fedCtx);
                String redirectURL = redirectionResponse.getRedirectionURL();
                if (redirectURL != null) {
                    Map headers = redirectionResponse.getHeaders();
                    if (!headers.isEmpty()) {
                        for (Map.Entry entry : headers.entrySet()) {
                            response.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    try {
                        this.saveRequest(request, redirectionResponse.getRequestState());
                    }
                    catch (IOException ioe) {
                        LOG.debug("Request body too big to save during authentication");
                        response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                    }
                    response.sendRedirect(redirectURL);
                    break block7;
                }
                LOG.warn("Failed to create SignInRequest.");
                response.sendError(500, "Failed to create SignInRequest.");
            }
            catch (ProcessingException ex) {
                LOG.warn("Failed to create SignInRequest: {}", (Object)ex.getMessage());
                response.sendError(500, "Failed to create SignInRequest.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchRequest(Request request) {
        SavedRequest saved;
        Session session = request.getSessionInternal(false);
        String uri = request.getDecodedRequestURI();
        if (session != null && uri != null && (saved = (SavedRequest)session.getNote(SESSION_SAVED_REQUEST_PREFIX + uri)) != null) {
            Session session2 = session;
            synchronized (session2) {
                session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
                return super.matchRequest(request);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRequest(Request request, RequestState requestState) throws IOException {
        String contextId = requestState.getState();
        String uri = request.getDecodedRequestURI();
        Session session = request.getSessionInternal(true);
        if (session != null) {
            LOG.debug("Save request in session '{}'", (Object)session.getIdInternal());
        }
        if (session != null && uri != null) {
            SavedRequest saved;
            Session session2 = session;
            synchronized (session2) {
                super.saveRequest(request, session);
                saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
            }
            session.setNote(SESSION_SAVED_REQUEST_PREFIX + uri, (Object)saved);
            StringBuilder sb = new StringBuilder(saved.getRequestURI());
            if (saved.getQueryString() != null) {
                sb.append('?');
                sb.append(saved.getQueryString());
            }
            session.setNote(SESSION_SAVED_URI_PREFIX + contextId, (Object)sb.toString());
            request.getSession().setAttribute("SAVED_REQUEST_STATE_" + requestState.getState(), (Object)requestState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean restoreRequest(Request request) throws IOException {
        SavedRequest saved;
        Session session = request.getSessionInternal(false);
        String uri = request.getDecodedRequestURI();
        if (session != null && uri != null && (saved = (SavedRequest)session.getNote(SESSION_SAVED_REQUEST_PREFIX + uri)) != null) {
            session.removeNote(SESSION_SAVED_REQUEST_PREFIX + uri);
            Session session2 = session;
            synchronized (session2) {
                session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
                return super.restoreRequest(request, session);
            }
        }
        return false;
    }

    protected boolean checkUserAuthentication(Request request, HttpServletResponse response, FedizContext fedCtx) {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            LOG.debug("Already authenticated '{}'", (Object)principal.getName());
            if (fedCtx.isDetectExpiredTokens()) {
                return this.validateToken(request, response, fedCtx);
            }
            LOG.debug("Token expiration not validated.");
            return true;
        }
        return false;
    }

    protected boolean validateToken(Request request, HttpServletResponse response, FedizContext fedConfig) {
        Session session = request.getSessionInternal();
        if (session != null) {
            FedizResponse wfRes = (FedizResponse)session.getNote(FEDERATION_NOTE);
            Instant tokenExpires = wfRes.getTokenExpires();
            if (tokenExpires == null) {
                LOG.debug("Token doesn't expire");
                return true;
            }
            Instant currentTime = Instant.now();
            if (!currentTime.isAfter(tokenExpires)) {
                return true;
            }
            LOG.warn("Token already expired. Clean up and redirect");
            session.removeNote(FEDERATION_NOTE);
            session.setPrincipal(null);
            request.getSession().removeAttribute(SECURITY_TOKEN);
        } else {
            LOG.debug("Session should not be null after authentication");
        }
        return false;
    }

    protected String getAuthMethod() {
        return "WSFED";
    }
}

