/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.util;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.TokenTypeBearing;
import org.opensaml.soap.wssecurity.UsageBearing;

public final class WSSecuritySupport {
    private WSSecuritySupport() {
    }

    public static void addWSUId(@Nonnull XMLObject soapObject, @Nonnull @NotEmpty String id) {
        if (soapObject instanceof IdBearing) {
            ((IdBearing)soapObject).setWSUId(id);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(IdBearing.WSU_ID_ATTR_NAME, id);
        } else {
            throw new IllegalArgumentException("Specified object was neither IdBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static String getWSUId(@Nonnull XMLObject soapObject) {
        String value = null;
        if (soapObject instanceof IdBearing && (value = StringSupport.trimOrNull((String)((IdBearing)soapObject).getWSUId())) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)IdBearing.WSU_ID_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addWSSE11TokenType(@Nonnull XMLObject soapObject, @Nullable String tokenType) {
        if (soapObject instanceof TokenTypeBearing) {
            ((TokenTypeBearing)soapObject).setWSSE11TokenType(tokenType);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(TokenTypeBearing.WSSE11_TOKEN_TYPE_ATTR_NAME, tokenType);
        } else {
            throw new IllegalArgumentException("Specified object was neither TokenTypeBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static String getWSSE11TokenType(@Nonnull XMLObject soapObject) {
        String value = null;
        if (soapObject instanceof TokenTypeBearing && (value = StringSupport.trimOrNull((String)((TokenTypeBearing)soapObject).getWSSE11TokenType())) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject) {
            value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)TokenTypeBearing.WSSE11_TOKEN_TYPE_ATTR_NAME));
            return value;
        }
        return null;
    }

    public static void addWSSEUsage(@Nonnull XMLObject soapObject, @Nonnull @NotEmpty String usage) {
        if (soapObject instanceof UsageBearing) {
            UsageBearing usageBearing = (UsageBearing)soapObject;
            LazyList list = usageBearing.getWSSEUsages();
            if (list == null) {
                list = new LazyList();
                usageBearing.setWSSEUsages((List<String>)list);
            }
            list.add((String)usage);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            AttributeMap am = ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes();
            Object list = am.get((Object)UsageBearing.WSSE_USAGE_ATTR_NAME);
            list = list == null ? usage : (String)list + " " + usage;
            am.put(UsageBearing.WSSE_USAGE_ATTR_NAME, (String)list);
        } else {
            throw new IllegalArgumentException("Specified object was neither UsageBearing nor AttributeExtensible");
        }
    }

    public static void addWSSEUsages(@Nonnull XMLObject soapObject, @Nonnull List<String> usages) {
        if (soapObject instanceof UsageBearing) {
            ((UsageBearing)soapObject).setWSSEUsages(usages);
        } else if (soapObject instanceof AttributeExtensibleXMLObject) {
            ((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().put(UsageBearing.WSSE_USAGE_ATTR_NAME, StringSupport.listToStringValue(usages, (String)" "));
        } else {
            throw new IllegalArgumentException("Specified object was neither UsageBearing nor AttributeExtensible");
        }
    }

    @Nullable
    public static List<String> getWSSEUsages(@Nonnull XMLObject soapObject) {
        Object value;
        if (soapObject instanceof UsageBearing && (value = ((UsageBearing)soapObject).getWSSEUsages()) != null) {
            return value;
        }
        if (soapObject instanceof AttributeExtensibleXMLObject && (value = StringSupport.trimOrNull((String)((AttributeExtensibleXMLObject)soapObject).getUnknownAttributes().get((Object)UsageBearing.WSSE_USAGE_ATTR_NAME))) != null) {
            StringSupport.stringToList((String)value, (String)" \n\r\t");
        }
        return null;
    }
}

