/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationStreamConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationTransformerConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.Preconditions;

public abstract class FederationStreamConnectMessage<T extends FederationStreamConfiguration>
extends PacketImpl {
    private String name;
    private FederationConfiguration.Credentials credentials;
    private Map<String, FederationPolicy> federationPolicyMap = new HashMap<String, FederationPolicy>();
    private Map<String, FederationTransformerConfiguration> transformerConfigurationMap = new HashMap<String, FederationTransformerConfiguration>();
    private T streamConfiguration;

    public FederationStreamConnectMessage(byte type) {
        super(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FederationConfiguration.Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(FederationConfiguration.Credentials credentials) {
        this.credentials = credentials;
    }

    public T getStreamConfiguration() {
        return this.streamConfiguration;
    }

    public void setStreamConfiguration(T streamConfiguration) {
        this.streamConfiguration = streamConfiguration;
    }

    public Map<String, FederationPolicy> getFederationPolicyMap() {
        return this.federationPolicyMap;
    }

    public void setFederationPolicyMap(Map<String, FederationPolicy> federationPolicyMap) {
        this.federationPolicyMap = federationPolicyMap;
    }

    public Map<String, FederationTransformerConfiguration> getTransformerConfigurationMap() {
        return this.transformerConfigurationMap;
    }

    public void setTransformerConfigurationMap(Map<String, FederationTransformerConfiguration> transformerConfigurationMap) {
        this.transformerConfigurationMap = transformerConfigurationMap;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        Preconditions.checkNotNull(this.streamConfiguration);
        super.encodeRest(buffer);
        buffer.writeString(this.name);
        if (this.credentials != null) {
            buffer.writeBoolean(true);
            this.credentials.encode(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.federationPolicyMap == null ? 0 : this.federationPolicyMap.size());
        if (this.federationPolicyMap != null) {
            for (FederationPolicy policy : this.federationPolicyMap.values()) {
                buffer.writeString(policy.getClass().getName());
                policy.encode(buffer);
            }
        }
        buffer.writeInt(this.transformerConfigurationMap == null ? 0 : this.transformerConfigurationMap.size());
        if (this.transformerConfigurationMap != null) {
            for (FederationTransformerConfiguration transformerConfiguration : this.transformerConfigurationMap.values()) {
                transformerConfiguration.encode(buffer);
            }
        }
        ((FederationStreamConfiguration)this.streamConfiguration).encode(buffer);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.name = buffer.readString();
        boolean hasCredentials = buffer.readBoolean();
        if (hasCredentials) {
            this.credentials = new FederationConfiguration.Credentials();
            this.credentials.decode(buffer);
        }
        int policySize = buffer.readInt();
        for (int i = 0; i < policySize; ++i) {
            String clazz = buffer.readString();
            FederationPolicy policy = this.getFederationPolicy(clazz);
            policy.decode(buffer);
            this.federationPolicyMap.put(policy.getName(), policy);
        }
        int transformerSize = buffer.readInt();
        for (int i = 0; i < transformerSize; ++i) {
            FederationTransformerConfiguration transformerConfiguration = new FederationTransformerConfiguration();
            transformerConfiguration.decode(buffer);
            this.transformerConfigurationMap.put(transformerConfiguration.getName(), transformerConfiguration);
        }
        this.streamConfiguration = this.decodeStreamConfiguration(buffer);
    }

    protected abstract T decodeStreamConfiguration(ActiveMQBuffer var1);

    private FederationPolicy getFederationPolicy(String clazz) {
        try {
            return (FederationPolicy)ClassloadingUtil.getInstanceWithTypeCheck((String)clazz, FederationPolicy.class, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new IllegalStateException("Error. Unable to instantiate FederationPolicy: " + e.getMessage(), e);
        }
    }
}

