/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Tag;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Tags
implements Iterable<Tag> {
    private static final Tags EMPTY = new Tags(new Tag[0], 0);
    private final Tag[] sortedSet;
    private final int length;

    private Tags(Tag[] sortedSet, int length) {
        this.sortedSet = sortedSet;
        this.length = length;
    }

    private static boolean isSortedSet(Tag[] tags, int length) {
        if (length > tags.length) {
            return false;
        }
        for (int i = 0; i < length - 1; ++i) {
            int cmp = tags[i].compareTo(tags[i + 1]);
            if (cmp < 0) continue;
            return false;
        }
        return true;
    }

    private static Tags make(Tag[] tags) {
        int len = tags.length;
        if (!Tags.isSortedSet(tags, len)) {
            Arrays.sort(tags);
            len = Tags.dedup(tags);
        }
        return new Tags(tags, len);
    }

    private static int dedup(Tag[] tags) {
        int n = tags.length;
        if (n == 0 || n == 1) {
            return n;
        }
        int j = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (tags[i].getKey().equals(tags[i + 1].getKey())) continue;
            tags[j++] = tags[i];
        }
        tags[j++] = tags[n - 1];
        return j;
    }

    private Tags merged(Tags other) {
        if (other.length == 0) {
            return this;
        }
        if (Objects.equals(this, other)) {
            return this;
        }
        Tag[] sortedSet = new Tag[this.length + other.length];
        int sortedIdx = 0;
        int thisIdx = 0;
        int otherIdx = 0;
        while (thisIdx < this.length && otherIdx < other.length) {
            int cmp = this.sortedSet[thisIdx].compareTo(other.sortedSet[otherIdx]);
            if (cmp > 0) {
                sortedSet[sortedIdx] = other.sortedSet[otherIdx];
                ++otherIdx;
            } else if (cmp < 0) {
                sortedSet[sortedIdx] = this.sortedSet[thisIdx];
                ++thisIdx;
            } else {
                sortedSet[sortedIdx] = other.sortedSet[otherIdx];
                ++thisIdx;
                ++otherIdx;
            }
            ++sortedIdx;
        }
        int thisRemaining = this.length - thisIdx;
        if (thisRemaining > 0) {
            System.arraycopy(this.sortedSet, thisIdx, sortedSet, sortedIdx, thisRemaining);
            sortedIdx += thisRemaining;
        }
        int otherRemaining = other.length - otherIdx;
        if (otherIdx < other.sortedSet.length) {
            System.arraycopy(other.sortedSet, otherIdx, sortedSet, sortedIdx, otherRemaining);
            sortedIdx += otherRemaining;
        }
        return new Tags(sortedSet, sortedIdx);
    }

    public Tags and(String key, String value) {
        return this.and(Tag.of(key, value));
    }

    public Tags and(String ... keyValues) {
        if (Tags.blankVarargs(keyValues)) {
            return this;
        }
        return this.and(Tags.of(keyValues));
    }

    public Tags and(Tag ... tags) {
        if (Tags.blankVarargs(tags)) {
            return this;
        }
        return this.and(Tags.make(tags));
    }

    public Tags and(@Nullable Iterable<? extends Tag> tags) {
        if (tags == null || tags == EMPTY || !tags.iterator().hasNext()) {
            return this;
        }
        if (this.length == 0) {
            return Tags.of(tags);
        }
        return this.merged(Tags.of(tags));
    }

    @Override
    public Iterator<Tag> iterator() {
        return new ArrayIterator();
    }

    @Override
    public Spliterator<Tag> spliterator() {
        return Spliterators.spliterator(this.sortedSet, 0, this.length, 1301);
    }

    public Stream<Tag> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.sortedSet[i].hashCode();
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.tagsEqual((Tags)obj);
    }

    private boolean tagsEqual(Tags obj) {
        if (this.sortedSet == obj.sortedSet) {
            return true;
        }
        if (this.length != obj.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.sortedSet[i].equals(obj.sortedSet[i])) continue;
            return false;
        }
        return true;
    }

    public static Tags concat(@Nullable Iterable<? extends Tag> tags, @Nullable Iterable<? extends Tag> otherTags) {
        return Tags.of(tags).and(otherTags);
    }

    public static Tags concat(@Nullable Iterable<? extends Tag> tags, String ... keyValues) {
        return Tags.of(tags).and(keyValues);
    }

    public static Tags of(@Nullable Iterable<? extends Tag> tags) {
        if (tags == null || tags == EMPTY || !tags.iterator().hasNext()) {
            return Tags.empty();
        }
        if (tags instanceof Tags) {
            return (Tags)tags;
        }
        if (tags instanceof Collection) {
            Collection tagsCollection = (Collection)tags;
            return Tags.make(tagsCollection.toArray(new Tag[0]));
        }
        return Tags.make((Tag[])StreamSupport.stream(tags.spliterator(), false).toArray(Tag[]::new));
    }

    public static Tags of(String key, String value) {
        return new Tags(new Tag[]{Tag.of(key, value)}, 1);
    }

    public static Tags of(String ... keyValues) {
        if (Tags.blankVarargs(keyValues)) {
            return Tags.empty();
        }
        if (keyValues.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        Tag[] tags = new Tag[keyValues.length / 2];
        for (int i = 0; i < keyValues.length; i += 2) {
            tags[i / 2] = Tag.of(keyValues[i], keyValues[i + 1]);
        }
        return Tags.make(tags);
    }

    private static boolean blankVarargs(@Nullable Object[] args) {
        return args == null || args.length == 0 || args.length == 1 && args[0] == null;
    }

    public static Tags of(Tag ... tags) {
        return Tags.empty().and(tags);
    }

    public static Tags empty() {
        return EMPTY;
    }

    public String toString() {
        return this.stream().map((Function<Tag, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/micrometer/core/instrument/Tag;)Ljava/lang/String;)()).collect(Collectors.joining(",", "[", "]"));
    }

    private class ArrayIterator
    implements Iterator<Tag> {
        private int currentIndex = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < Tags.this.length;
        }

        @Override
        public Tag next() {
            return Tags.this.sortedSet[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from tags");
        }
    }
}

