/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.TopologyManager;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Topology {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private Executor executor;
    private volatile Object owner;
    private final TopologyManager manager;
    private final Map<String, TopologyMemberImpl> topology = new ConcurrentHashMap<String, TopologyMemberImpl>();
    private Map<String, Long> mapDelete;

    public Topology(Object owner) {
        this(owner, new DirectExecutor());
    }

    public Topology(Object owner, Executor executor) {
        TopologyManager topologyManager;
        if (executor == null) {
            throw new IllegalArgumentException("Executor is required");
        }
        this.executor = executor;
        this.owner = owner;
        this.manager = owner instanceof TopologyManager ? (topologyManager = (TopologyManager)owner) : null;
        if (logger.isTraceEnabled()) {
            logger.trace("Topology@{} CREATE", (Object)Integer.toHexString(System.identityHashCode(this)), (Object)new Exception("trace"));
        }
    }

    public Topology setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public synchronized void clear() {
        this.topology.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}::Adding topology listener {}", new Object[]{this, listener, new Exception("Trace")});
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.add(listener);
        }
        this.sendTopology(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}::Removing topology listener {}", new Object[]{this, listener, new Exception("Trace")});
        }
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            this.topologyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsPrimary(String nodeId, TopologyMemberImpl memberInput) {
        Topology topology = this;
        synchronized (topology) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}::node {}={}", new Object[]{this, nodeId, memberInput});
            }
            memberInput.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, memberInput);
            this.sendMemberUp(nodeId, memberInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendNode(String nodeId) {
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl memberInput = this.topology.get(nodeId);
            if (memberInput != null) {
                memberInput.setUniqueEventID(System.currentTimeMillis());
                this.sendMemberUp(nodeId, memberInput);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyMemberImpl updateBackup(TopologyMemberImpl memberInput) {
        String nodeId = memberInput.getNodeId();
        if (logger.isTraceEnabled()) {
            logger.trace("{}::updateBackup::{}, memberInput={}", new Object[]{this, nodeId, memberInput});
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl currentMember = this.getMember(nodeId);
            if (currentMember == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("There's no primary to be updated on backup update, node={} memberInput={}", new Object[]{nodeId, memberInput, new Exception("trace")});
                }
                currentMember = memberInput;
                this.topology.put(nodeId, currentMember);
            }
            TopologyMemberImpl newMember = new TopologyMemberImpl(nodeId, currentMember.getBackupGroupName(), currentMember.getScaleDownGroupName(), currentMember.getPrimary(), memberInput.getBackup());
            newMember.setUniqueEventID(System.currentTimeMillis());
            this.topology.remove(nodeId);
            this.topology.put(nodeId, newMember);
            this.sendMemberUp(nodeId, newMember);
            return newMember;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMember(long uniqueEventID, String nodeId, TopologyMemberImpl memberInput) {
        Long deleteTme = this.getMapDelete().get(nodeId);
        if (deleteTme != null && uniqueEventID != 0L && uniqueEventID < deleteTme) {
            if (logger.isDebugEnabled()) {
                logger.debug("Update uniqueEvent={}, nodeId={}, memberInput={} being rejected as there was a delete done after that", new Object[]{uniqueEventID, nodeId, memberInput});
            }
            return false;
        }
        if (this.manager != null && !this.manager.updateMember(uniqueEventID, nodeId, memberInput)) {
            logger.debug("TopologyManager rejected the update towards {}", (Object)memberInput);
            return false;
        }
        Topology topology = this;
        synchronized (topology) {
            TopologyMemberImpl currentMember = this.topology.get(nodeId);
            if (currentMember == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("{}::NewMemberAdd nodeId={} member = {}", new Object[]{this, nodeId, memberInput, new Exception("trace")});
                }
                memberInput.setUniqueEventID(uniqueEventID);
                this.topology.put(nodeId, memberInput);
                this.sendMemberUp(nodeId, memberInput);
                return true;
            }
            if (uniqueEventID > currentMember.getUniqueEventID() || currentMember.getPrimary() == null && memberInput.getPrimary() != null) {
                TopologyMemberImpl newMember = new TopologyMemberImpl(nodeId, memberInput.getBackupGroupName(), memberInput.getScaleDownGroupName(), memberInput.getPrimary(), memberInput.getBackup());
                if (newMember.getPrimary() == null && currentMember.getPrimary() != null) {
                    newMember.setPrimary(currentMember.getPrimary());
                }
                if (newMember.getBackup() == null && currentMember.getBackup() != null) {
                    newMember.setBackup(currentMember.getBackup());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("{}::updated currentMember=nodeID={}, currentMember={}, memberInput={} newMember={}", new Object[]{this, nodeId, currentMember, memberInput, newMember, new Exception("trace")});
                }
                if (uniqueEventID > currentMember.getUniqueEventID()) {
                    newMember.setUniqueEventID(uniqueEventID);
                } else {
                    newMember.setUniqueEventID(currentMember.getUniqueEventID());
                }
                this.topology.remove(nodeId);
                this.topology.put(nodeId, newMember);
                this.sendMemberUp(nodeId, newMember);
                return true;
            }
            if (currentMember.getBackup() == null && memberInput.getBackup() != null) {
                currentMember.setBackup(memberInput.getBackup());
            }
            return false;
        }
    }

    private void sendMemberUp(String nodeId, TopologyMemberImpl memberToSend) {
        List<ClusterTopologyListener> copy = this.copyListeners();
        if (logger.isTraceEnabled()) {
            logger.trace("{}::prepare to send {} to {} elements", new Object[]{this, nodeId, copy.size()});
        }
        if (!copy.isEmpty()) {
            this.executor.execute(() -> {
                for (ClusterTopologyListener listener : copy) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("{} informing {} about node up = {} connector = {}", new Object[]{this, listener, nodeId, memberToSend.getConnector()});
                    }
                    try {
                        listener.nodeUP(memberToSend, false);
                    }
                    catch (Throwable e) {
                        ActiveMQClientLogger.LOGGER.errorSendingTopology(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClusterTopologyListener> copyListeners() {
        ArrayList<ClusterTopologyListener> listenersCopy;
        Set<ClusterTopologyListener> set = this.topologyListeners;
        synchronized (set) {
            listenersCopy = new ArrayList<ClusterTopologyListener>(this.topologyListeners);
        }
        return listenersCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeMember(final long uniqueEventID, final String nodeId, boolean disconnect) {
        TopologyMemberImpl member;
        if (this.manager != null && !this.manager.removeMember(uniqueEventID, nodeId, disconnect)) {
            logger.debug("TopologyManager rejected the update towards {}", (Object)nodeId);
            return false;
        }
        Topology topology = this;
        synchronized (topology) {
            member = this.topology.get(nodeId);
            if (member != null) {
                if (member.getUniqueEventID() > uniqueEventID) {
                    logger.debug("The removeMember was issued before the node {} was started, ignoring call", (Object)nodeId);
                    member = null;
                } else {
                    this.getMapDelete().put(nodeId, uniqueEventID);
                    member = this.topology.remove(nodeId);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("removeMember {} removing nodeID={}, result={}, size = {}", new Object[]{this, nodeId, member, this.topology.size(), new Exception("trace")});
        }
        if (member != null) {
            final List<ClusterTopologyListener> copy = this.copyListeners();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ClusterTopologyListener listener : copy) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("{} informing {} about node down = {}", new Object[]{this, listener, nodeId});
                        }
                        try {
                            listener.nodeDown(uniqueEventID, nodeId);
                        }
                        catch (Exception e) {
                            ActiveMQClientLogger.LOGGER.errorSendingTopologyNodedown(e);
                        }
                    }
                }
            });
        }
        return member != null;
    }

    public synchronized void sendTopology(ClusterTopologyListener listener) {
        logger.debug("{} is sending topology to {}", (Object)this, (Object)listener);
        this.executor.execute(() -> {
            HashMap<String, TopologyMemberImpl> copy;
            int count = 0;
            Topology topology = this;
            synchronized (topology) {
                copy = new HashMap<String, TopologyMemberImpl>(this.topology);
            }
            for (Map.Entry entry : copy.entrySet()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} sending {} / {} to {}", new Object[]{this, entry.getKey(), ((TopologyMemberImpl)entry.getValue()).getConnector(), listener});
                }
                listener.nodeUP((TopologyMember)entry.getValue(), ++count == copy.size());
            }
        });
    }

    public synchronized TopologyMemberImpl getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public synchronized TopologyMemberImpl getMember(RemotingConnection rc) {
        for (TopologyMemberImpl member : this.topology.values()) {
            if (!member.isMember(rc)) continue;
            return member;
        }
        return null;
    }

    public synchronized boolean isEmpty() {
        return this.topology.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TopologyMemberImpl> getMembers() {
        ArrayList<TopologyMemberImpl> members;
        Topology topology = this;
        synchronized (topology) {
            members = new ArrayList<TopologyMemberImpl>(this.topology.values());
        }
        return members;
    }

    synchronized int nodes() {
        int count = 0;
        for (TopologyMemberImpl member : this.topology.values()) {
            if (member.getPrimary() != null) {
                ++count;
            }
            if (member.getBackup() == null) continue;
            ++count;
        }
        return count;
    }

    public synchronized String describe() {
        return this.describe("");
    }

    private synchronized String describe(String text) {
        StringBuilder desc = new StringBuilder(text + "topology on " + String.valueOf(this) + ":\n");
        for (Map.Entry<String, TopologyMemberImpl> entry : new HashMap<String, TopologyMemberImpl>(this.topology).entrySet()) {
            desc.append("\t").append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
        }
        desc.append("\tnodes=").append(this.nodes()).append("\t").append("members=").append(this.members());
        if (this.topology.isEmpty()) {
            desc.append("\tEmpty");
        }
        return desc.toString();
    }

    private int members() {
        return this.topology.size();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public TransportConfiguration getBackupForConnector(Connector connector) {
        for (TopologyMemberImpl member : this.topology.values()) {
            if (member.getPrimary() == null || !connector.isEquivalent(member.getPrimary().getParams())) continue;
            return member.getBackup();
        }
        return null;
    }

    public String toString() {
        if (this.owner == null) {
            return "Topology@" + Integer.toHexString(System.identityHashCode(this));
        }
        return "Topology@" + Integer.toHexString(System.identityHashCode(this)) + "[owner=" + String.valueOf(this.owner) + "]";
    }

    private synchronized Map<String, Long> getMapDelete() {
        if (this.mapDelete == null) {
            this.mapDelete = new ConcurrentHashMap<String, Long>();
        }
        return this.mapDelete;
    }

    private static final class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

