/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security.impl;

import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.IPRange;
import net.shibboleth.utilities.java.support.security.AccessControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPRangeAccessControl
extends AbstractIdentifiableInitializableComponent
implements AccessControl {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IPRangeAccessControl.class);
    @Nonnull
    @NonnullElements
    private Collection<IPRange> allowedRanges = Collections.emptyList();

    public void setAllowedRanges(@Nonnull @NonnullElements Collection<IPRange> ranges) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        Constraint.isNotNull(ranges, "IPRange collection cannot be null");
        this.allowedRanges = List.copyOf(ranges);
    }

    @Override
    public boolean checkAccess(@Nonnull ServletRequest request, @Nullable String operation, @Nullable String resource) {
        Constraint.isNotNull(request, "ServletRequest cannot be null");
        String addr = HttpServletSupport.getRemoteAddr(request);
        if (addr != null) {
            this.log.debug("{} Evaluating client address '{}'", (Object)this.getLogPrefix(), (Object)addr);
            try {
                byte[] resolvedAddress = InetAddresses.forString((String)addr).getAddress();
                for (IPRange range : this.allowedRanges) {
                    if (!range.contains(resolvedAddress)) continue;
                    this.log.debug("{} Granted access to client address '{}' (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), addr, operation, resource});
                    return true;
                }
            }
            catch (IllegalArgumentException e) {
                this.log.warn("{} Error translating client address", (Object)this.getLogPrefix(), (Object)e);
            }
            this.log.warn("{} Denied request from client address '{}' (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), addr, operation, resource});
        } else {
            this.log.warn("{} Denied request from client address 'unknown' (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), operation, resource});
        }
        return false;
    }

    @Nonnull
    private String getLogPrefix() {
        return "Policy " + this.getId() + ":";
    }
}

