/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.stream.Stream;

public final class URLArray {
    public static URL[] fromPaths(Iterable<String> files) {
        return URLArray.fromFiles(() -> URLArray.stream(files).map(e -> e == null ? null : new File((String)e)).iterator());
    }

    public static URL[] fromFiles(Iterable<File> files) {
        return URLArray.fromFiles(URLArray.stream(files));
    }

    private static URL[] fromFiles(Stream<File> files) {
        return (URL[])files.map(f -> {
            if (f == null) {
                return null;
            }
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
    }

    private static <T> Stream<T> stream(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).stream();
        }
        Stream.Builder builder = Stream.builder();
        iterable.forEach(builder);
        return builder.build();
    }

    private URLArray() {
    }
}

