/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.weaver.ant._lang3.AnnotationUtils;
import org.apache.commons.weaver.ant._lang3.Validate;

public final class Annotations {
    private Annotations() {
    }

    public static <A extends Annotation> A instanceOf(final Class<A> annotationType, final Map<String, ?> elements) {
        ClassLoader proxyClassLoader = Validate.notNull(annotationType, "annotationType", new Object[0]).getClassLoader();
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().equals(annotationType)) {
                    if (elements.containsKey(method.getName())) {
                        return elements.get(method.getName());
                    }
                    return method.getDefaultValue();
                }
                if ("annotationType".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return annotationType;
                }
                if ("equals".equals(method.getName()) && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class})) {
                    return AnnotationUtils.equals((Annotation)proxy, (Annotation)args[0]);
                }
                if ("hashCode".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return AnnotationUtils.hashCode((Annotation)proxy);
                }
                if ("toString".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return AnnotationUtils.toString((Annotation)proxy);
                }
                throw new UnsupportedOperationException();
            }
        };
        Annotation result = (Annotation)Proxy.newProxyInstance(proxyClassLoader, new Class[]{annotationType}, invocationHandler);
        return (A)result;
    }
}

