/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.weaver.ant._xbean.finder.AnnotationFinder;
import org.apache.commons.weaver.ant._xbean.finder.Parameter;
import org.apache.commons.weaver.model.ScanResult;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeavableConstructor;
import org.apache.commons.weaver.model.WeavableConstructorParameter;
import org.apache.commons.weaver.model.WeavableField;
import org.apache.commons.weaver.model.WeavableMethod;
import org.apache.commons.weaver.model.WeavableMethodParameter;
import org.apache.commons.weaver.model.WeavablePackage;
import org.apache.commons.weaver.model.WeavableParameter;

class Inflater {
    final Map<AnnotationFinder.PackageInfo, List<Annotation>> packageAnnotations;
    final Map<AnnotationFinder.ClassInfo, List<Annotation>> classAnnotations;
    final Map<AnnotationFinder.FieldInfo, List<Annotation>> fieldAnnotations;
    final Map<AnnotationFinder.MethodInfo, List<Annotation>> ctorAnnotations;
    final Map<AnnotationFinder.MethodInfo, List<Annotation>> methodAnnotations;
    final Map<AnnotationFinder.ParameterInfo, List<Annotation>> ctorParameterAnnotations;
    final Map<AnnotationFinder.ParameterInfo, List<Annotation>> methodParameterAnnotations;

    Inflater(Map<AnnotationFinder.Info, List<Annotation>> annotationMap) {
        this.packageAnnotations = Inflater.subMap(annotationMap, new InfoMatcher(AnnotationFinder.PackageInfo.class));
        this.classAnnotations = Inflater.subMap(annotationMap, new InfoMatcher(AnnotationFinder.ClassInfo.class));
        this.fieldAnnotations = Inflater.subMap(annotationMap, new InfoMatcher(AnnotationFinder.FieldInfo.class));
        this.ctorAnnotations = Inflater.subMap(annotationMap, new MethodMatcher(true));
        this.methodAnnotations = Inflater.subMap(annotationMap, new MethodMatcher(false));
        this.ctorParameterAnnotations = Inflater.subMap(annotationMap, new ParameterMatcher(true));
        this.methodParameterAnnotations = Inflater.subMap(annotationMap, new ParameterMatcher(false));
    }

    static <I extends AnnotationFinder.Info> Map<I, List<Annotation>> subMap(Map<AnnotationFinder.Info, List<Annotation>> source, InfoMatcher matcher) {
        Map<AnnotationFinder.Info, List> result = source.entrySet().stream().filter(e -> matcher.test((AnnotationFinder.Info)e.getKey())).collect(Collectors.toMap(t -> (AnnotationFinder.Info)t.getKey(), Map.Entry::getValue));
        return result;
    }

    ScanResult inflate(ScanResult scanResult) {
        for (WeavablePackage pkg : scanResult.getPackages()) {
            this.packageAnnotations.forEach((k, v) -> {
                if (k.getName().equals(((Package)pkg.getTarget()).getName())) {
                    pkg.addAnnotations((Iterable<Annotation>)v);
                }
            });
            for (WeavableClass<?> cls : pkg.getClasses()) {
                this.classAnnotations.forEach((k, v) -> {
                    if (k.getName().equals(((Class)cls.getTarget()).getName())) {
                        cls.addAnnotations((Iterable<Annotation>)v);
                    }
                });
                for (WeavableField<?> weavableField : cls.getFields()) {
                    this.fieldAnnotations.forEach((k, v) -> {
                        try {
                            if (k.get().equals(fld.getTarget())) {
                                fld.addAnnotations((Iterable<Annotation>)v);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    });
                }
                for (WeavableConstructor weavableConstructor : cls.getConstructors()) {
                    this.ctorAnnotations.forEach((k, v) -> {
                        try {
                            if (k.get().equals(ctor.getTarget())) {
                                ctor.addAnnotations((Iterable<Annotation>)v);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    });
                    for (WeavableParameter param : weavableConstructor.getParameters()) {
                        this.ctorParameterAnnotations.forEach((arg_0, arg_1) -> Inflater.lambda$inflate$6(weavableConstructor, (WeavableConstructorParameter)param, arg_0, arg_1));
                    }
                }
                for (WeavableMethod weavableMethod : cls.getMethods()) {
                    this.methodAnnotations.forEach((k, v) -> {
                        try {
                            if (k.get().equals(methd.getTarget())) {
                                methd.addAnnotations((Iterable<Annotation>)v);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    });
                    for (WeavableParameter param : weavableMethod.getParameters()) {
                        this.methodParameterAnnotations.forEach((arg_0, arg_1) -> Inflater.lambda$inflate$8(weavableMethod, (WeavableMethodParameter)param, arg_0, arg_1));
                    }
                }
            }
        }
        return scanResult;
    }

    private static /* synthetic */ void lambda$inflate$8(WeavableMethod methd, WeavableMethodParameter param, AnnotationFinder.ParameterInfo k, List v) {
        try {
            Parameter<?> parameter = k.get();
            if (parameter.getDeclaringExecutable().equals(methd.getTarget()) && ((Integer)param.getTarget()).intValue() == parameter.getIndex()) {
                param.addAnnotations(v);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$inflate$6(WeavableConstructor ctor, WeavableConstructorParameter param, AnnotationFinder.ParameterInfo k, List v) {
        try {
            Parameter<?> parameter = k.get();
            if (parameter.getDeclaringExecutable().equals(ctor.getTarget()) && ((Integer)param.getTarget()).intValue() == parameter.getIndex()) {
                param.addAnnotations(v);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private class ParameterMatcher
    extends InfoMatcher {
        final boolean isCtor;

        ParameterMatcher(boolean isCtor) {
            super(AnnotationFinder.ParameterInfo.class);
            this.isCtor = isCtor;
        }

        @Override
        public boolean test(AnnotationFinder.Info info) {
            return super.test(info) && ((AnnotationFinder.ParameterInfo)info).getDeclaringMethod().isConstructor() == this.isCtor;
        }
    }

    private class MethodMatcher
    extends InfoMatcher {
        final boolean isCtor;

        MethodMatcher(boolean isCtor) {
            super(AnnotationFinder.MethodInfo.class);
            this.isCtor = isCtor;
        }

        @Override
        public boolean test(AnnotationFinder.Info info) {
            return super.test(info) && ((AnnotationFinder.MethodInfo)info).isConstructor() == this.isCtor;
        }
    }

    private class InfoMatcher
    implements Predicate<AnnotationFinder.Info> {
        final Class<? extends AnnotationFinder.Info> type;

        InfoMatcher(Class<? extends AnnotationFinder.Info> type) {
            this.type = type;
        }

        @Override
        public boolean test(AnnotationFinder.Info info) {
            return this.type.isInstance(info);
        }
    }
}

