/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileType;

public class FileInfo {
    String baseName;
    FileType type;
    String content;
    Map<String, FileInfo> children = new HashMap<String, FileInfo>();
    FileInfo parent;

    public FileInfo(String name, FileType type) {
        this.baseName = name;
        this.type = type;
        this.content = null;
    }

    public FileInfo(String name, FileType type, String content) {
        this.baseName = name;
        this.type = type;
        this.content = content;
    }

    public void addChild(FileInfo child) {
        this.children.put(child.baseName, child);
        child.parent = this;
    }

    public FileInfo addFile(String baseName, String content) {
        FileInfo child = new FileInfo(baseName, FileType.FILE, content);
        this.addChild(child);
        return child;
    }

    public FileInfo addFolder(String baseName) {
        FileInfo child = new FileInfo(baseName, FileType.FOLDER, null);
        this.addChild(child);
        return child;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Map<String, FileInfo> getChildren() {
        return this.children;
    }

    public String getContent() {
        return this.content;
    }

    public FileInfo getParent() {
        return this.parent;
    }

    public FileType getType() {
        return this.type;
    }
}

