/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.summary;

import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic {
    private long n;
    private double value;

    public SumOfSquares() {
        this.n = 0L;
        this.value = 0.0;
    }

    public SumOfSquares(SumOfSquares original) throws NullArgumentException {
        SumOfSquares.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value += d * d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double sumSq = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length, (boolean)true)) {
            sumSq = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sumSq += values[i] * values[i];
            }
        }
        return sumSq;
    }

    @Override
    public SumOfSquares copy() {
        SumOfSquares result = new SumOfSquares();
        SumOfSquares.copy(this, result);
        return result;
    }

    public static void copy(SumOfSquares source, SumOfSquares dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        dest.n = source.n;
        dest.value = source.value;
    }
}

