/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar;

import java.util.function.BiFunction;
import java.util.function.DoublePredicate;
import org.apache.commons.math4.legacy.optim.OptimizationData;
import org.apache.commons.math4.legacy.optim.nonlinear.scalar.noderiv.Simplex;
import org.apache.commons.math4.legacy.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.rng.UniformRandomProvider;

public class SimulatedAnnealing
implements OptimizationData {
    private final int epochDuration;
    private final double startProbability;
    private final double endProbability;
    private final CoolingSchedule coolingSchedule;
    private final UniformRandomProvider rng;

    public SimulatedAnnealing(int epoch, double startProb, double endProb, CoolingSchedule cooling, UniformRandomProvider random) {
        if (epoch < 1) {
            throw new IllegalArgumentException("Epoch out of range: " + epoch);
        }
        if (startProb < 0.0 || startProb > 1.0) {
            throw new IllegalArgumentException("Initial acceptance probability out of range: " + startProb);
        }
        if (endProb < 0.0 || endProb > 1.0) {
            throw new IllegalArgumentException("Final acceptance probability out of range: " + endProb);
        }
        if (endProb >= startProb) {
            throw new IllegalArgumentException("Final probability larger than initial probability");
        }
        this.epochDuration = epoch;
        this.startProbability = startProb;
        this.endProbability = endProb;
        this.coolingSchedule = cooling;
        this.rng = random;
    }

    public int getEpochDuration() {
        return this.epochDuration;
    }

    public double getStartProbability() {
        return this.startProbability;
    }

    public double getEndProbability() {
        return this.endProbability;
    }

    public CoolingSchedule getCoolingSchedule() {
        return this.coolingSchedule;
    }

    public DoublePredicate metropolis(double temperature) {
        return deltaE -> Math.exp(Math.abs(deltaE) / temperature) >= this.rng.nextDouble();
    }

    public static interface CoolingSchedule
    extends BiFunction<Double, Simplex, Double> {
        public static CoolingSchedule decreasingExponential(double f) {
            if (f <= 0.0 || f >= 1.0) {
                throw new IllegalArgumentException("Factor out of range: " + f);
            }
            return (previousTemperature, simplex) -> f * previousTemperature;
        }

        public static CoolingSchedule aarstAndVanLaarhoven(double delta) {
            if (delta <= 0.0) {
                throw new IllegalArgumentException("Trajectory parameter out of range: " + delta);
            }
            return (previousTemperature, simplex) -> {
                StandardDeviation stddev = new StandardDeviation();
                for (int i = 0; i < simplex.getSize(); ++i) {
                    stddev.increment((Double)simplex.get(i).getValue());
                }
                double sigma = stddev.getResult();
                double a = previousTemperature * Math.log(1.0 + delta);
                double b = 3.0 * sigma;
                return previousTemperature / (1.0 + a / b);
            };
        }
    }
}

