/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Collection;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest
extends JexlTestCase {
    public RangeTest() {
        super("RangeTest");
    }

    @Test
    public void testIntegerRangeOne() throws Exception {
        JexlExpression e = this.JEXL.createExpression("(1..1)");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof Collection));
        Collection c = (Collection)o;
        Assert.assertEquals((long)1L, (long)c.size());
        Object[] a = c.toArray();
        Assert.assertEquals((long)1L, (long)a.length);
        Assert.assertEquals((long)1L, (long)((Number)a[0]).intValue());
        Assert.assertFalse((boolean)((Boolean)this.JEXL.createScript("empty x", new String[]{"x"}).execute(null, new Object[]{e})));
    }

    @Test
    public void testIntegerRange() throws Exception {
        int l;
        JexlExpression e = this.JEXL.createExpression("(1..32)");
        MapContext jc = new MapContext();
        Object o0 = e.evaluate((JexlContext)jc);
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof Collection));
        Collection c = (Collection)o;
        Assert.assertEquals((long)32L, (long)c.size());
        Assert.assertNotSame((Object)o0, (Object)o);
        Assert.assertEquals((long)o0.hashCode(), (long)o.hashCode());
        Assert.assertEquals((Object)o0, (Object)o);
        int i = 0;
        for (Object v : c) {
            Assert.assertEquals((long)(++i), (long)((Number)v).intValue());
        }
        Assert.assertEquals((long)32L, (long)i);
        Integer[] aa = c.toArray(new Integer[32]);
        Assert.assertEquals((long)32L, (long)aa.length);
        for (l = 0; l < 32; ++l) {
            Assert.assertEquals((long)aa[l].intValue(), (long)(l + 1));
        }
        aa = c.toArray(new Integer[2]);
        Assert.assertEquals((long)32L, (long)aa.length);
        for (l = 0; l < 32; ++l) {
            Assert.assertEquals((long)aa[l].intValue(), (long)(l + 1));
        }
        aa = c.toArray(new Integer[34]);
        Assert.assertEquals((long)34L, (long)aa.length);
        for (l = 0; l < 32; ++l) {
            Assert.assertEquals((long)aa[l].intValue(), (long)(l + 1));
        }
        Object[] oaa = c.toArray();
        Assert.assertEquals((long)32L, (long)oaa.length);
        for (int l2 = 0; l2 < 32; ++l2) {
            Assert.assertEquals((Object)oaa[l2], (Object)(l2 + 1));
        }
    }

    @Test
    public void testLongRange() throws Exception {
        int l;
        JexlExpression e = this.JEXL.createExpression("(6789000001L..6789000032L)");
        MapContext jc = new MapContext();
        Object o0 = e.evaluate((JexlContext)jc);
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof Collection));
        Collection c = (Collection)o;
        Assert.assertEquals((long)32L, (long)c.size());
        Assert.assertFalse((boolean)((Boolean)this.JEXL.createScript("empty x", new String[]{"x"}).execute(null, new Object[]{e})));
        Assert.assertNotSame((Object)o0, (Object)o);
        Assert.assertEquals((long)o0.hashCode(), (long)o.hashCode());
        Assert.assertEquals((Object)o0, (Object)o);
        long i = 6789000000L;
        for (Object v : c) {
            Assert.assertEquals((long)(++i), (long)((Number)v).longValue());
        }
        Assert.assertEquals((long)6789000032L, (long)i);
        Long[] aa = c.toArray(new Long[32]);
        Assert.assertEquals((long)32L, (long)aa.length);
        for (l = 0; l < 32; ++l) {
            Assert.assertEquals((long)aa[l], (long)(6789000001L + (long)l));
        }
        aa = c.toArray(new Long[2]);
        Assert.assertEquals((long)32L, (long)aa.length);
        for (l = 0; l < 32; ++l) {
            Assert.assertEquals((long)aa[l], (long)(6789000001L + (long)l));
        }
        aa = c.toArray(new Long[34]);
        Assert.assertEquals((long)34L, (long)aa.length);
        for (l = 0; l < 32; ++l) {
            Assert.assertEquals((long)aa[l], (long)(6789000001L + (long)l));
        }
        Object[] oaa = c.toArray();
        Assert.assertEquals((long)32L, (long)oaa.length);
        for (int l2 = 0; l2 < 32; ++l2) {
            Assert.assertEquals((Object)oaa[l2], (Object)(6789000001L + (long)l2));
        }
    }

    @Test
    public void testIntegerSum() throws Exception {
        JexlScript e = this.JEXL.createScript("var s = 0; for(var i : (1..5)) { s = s + i; }; s");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((long)15L, (long)((Number)o).intValue());
    }

    @Test
    public void testIntegerContains() throws Exception {
        JexlScript e = this.JEXL.createScript("(x)->{ x =~ (1..10) }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc, new Object[]{5});
        Assert.assertEquals((Object)Boolean.TRUE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{0});
        Assert.assertEquals((Object)Boolean.FALSE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{100});
        Assert.assertEquals((Object)Boolean.FALSE, (Object)o);
    }

    @Test
    public void testLongSum() throws Exception {
        JexlScript e = this.JEXL.createScript("var s = 0; for(var i : (6789000001L..6789000001L)) { s = s + i; }; s");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((long)6789000001L, (long)((Number)o).longValue());
    }

    @Test
    public void testLongContains() throws Exception {
        JexlScript e = this.JEXL.createScript("(x)->{ x =~ (90000000001L..90000000010L) }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc, new Object[]{90000000005L});
        Assert.assertEquals((Object)Boolean.TRUE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{0});
        Assert.assertEquals((Object)Boolean.FALSE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{90000000011L});
        Assert.assertEquals((Object)Boolean.FALSE, (Object)o);
    }
}

