/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.DuckGetExecutor;
import org.apache.commons.jexl2.internal.DuckSetExecutor;
import org.apache.commons.jexl2.internal.Introspector;
import org.apache.commons.jexl2.internal.ListGetExecutor;
import org.apache.commons.jexl2.internal.ListSetExecutor;
import org.apache.commons.jexl2.internal.MapGetExecutor;
import org.apache.commons.jexl2.internal.MapSetExecutor;
import org.apache.commons.jexl2.internal.PropertyGetExecutor;
import org.apache.commons.jexl2.internal.PropertySetExecutor;
import org.apache.commons.jexl2.introspection.Uberspect;

public class DiscoveryTest
extends JexlTestCase {
    public void testBeanIntrospection() throws Exception {
        Uberspect uber = JexlEngine.getUberspect(null);
        Introspector intro = (Introspector)uber;
        Bean bean = new Bean("JEXL", "LXEJ");
        AbstractExecutor.Get get = intro.getGetExecutor((Object)bean, (Object)"value");
        AbstractExecutor.Set set = intro.getSetExecutor((Object)bean, (Object)"value", (Object)"foo");
        DiscoveryTest.assertTrue((String)"bean property getter", (boolean)(get instanceof PropertyGetExecutor));
        DiscoveryTest.assertTrue((String)"bean property setter", (boolean)(set instanceof PropertySetExecutor));
        DiscoveryTest.assertEquals((Object)get, (Object)uber.getPropertyGet((Object)bean, (Object)"value", null));
        DiscoveryTest.assertEquals((Object)set, (Object)uber.getPropertySet((Object)bean, (Object)"value", (Object)"foo", null));
        DiscoveryTest.assertFalse((boolean)get.equals((AbstractExecutor)intro.getGetExecutor((Object)bean, (Object)"eulav")));
        DiscoveryTest.assertFalse((boolean)set.equals((AbstractExecutor)intro.getSetExecutor((Object)bean, (Object)"eulav", (Object)"foo")));
        Object bar = set.execute((Object)bean, (Object)"bar");
        DiscoveryTest.assertEquals((Object)"bar", (Object)bar);
        DiscoveryTest.assertEquals((Object)"bar", (Object)get.execute((Object)bean));
        Object quux = set.tryExecute((Object)bean, (Object)"value", (Object)"quux");
        DiscoveryTest.assertEquals((Object)"quux", (Object)quux);
        DiscoveryTest.assertEquals((Object)"quux", (Object)get.execute((Object)bean));
        DiscoveryTest.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryExecute((Object)bean, (Object)"eulav", (Object)"nope"));
    }

    public void testDuckIntrospection() throws Exception {
        Uberspect uber = JexlEngine.getUberspect(null);
        Introspector intro = (Introspector)uber;
        Duck duck = new Duck("JEXL", "LXEJ");
        AbstractExecutor.Get get = intro.getGetExecutor((Object)duck, (Object)"value");
        AbstractExecutor.Set set = intro.getSetExecutor((Object)duck, (Object)"value", (Object)"foo");
        DiscoveryTest.assertTrue((String)"duck property getter", (boolean)(get instanceof DuckGetExecutor));
        DiscoveryTest.assertTrue((String)"duck property setter", (boolean)(set instanceof DuckSetExecutor));
        DiscoveryTest.assertEquals((Object)get, (Object)uber.getPropertyGet((Object)duck, (Object)"value", null));
        DiscoveryTest.assertEquals((Object)set, (Object)uber.getPropertySet((Object)duck, (Object)"value", (Object)"foo", null));
        DiscoveryTest.assertFalse((boolean)get.equals((AbstractExecutor)intro.getGetExecutor((Object)duck, (Object)"eulav")));
        DiscoveryTest.assertFalse((boolean)set.equals((AbstractExecutor)intro.getSetExecutor((Object)duck, (Object)"eulav", (Object)"foo")));
        Object bar = set.execute((Object)duck, (Object)"bar");
        DiscoveryTest.assertEquals((Object)"bar", (Object)bar);
        DiscoveryTest.assertEquals((Object)"bar", (Object)get.execute((Object)duck));
        Object quux = set.tryExecute((Object)duck, (Object)"value", (Object)"quux");
        DiscoveryTest.assertEquals((Object)"quux", (Object)quux);
        DiscoveryTest.assertEquals((Object)"quux", (Object)get.execute((Object)duck));
        DiscoveryTest.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryExecute((Object)duck, (Object)"eulav", (Object)"nope"));
    }

    public void testListIntrospection() throws Exception {
        Uberspect uber = JexlEngine.getUberspect(null);
        Introspector intro = (Introspector)uber;
        ArrayList<String> list = new ArrayList<String>();
        list.add("LIST");
        list.add("TSIL");
        AbstractExecutor.Get get = intro.getGetExecutor(list, (Object)1);
        AbstractExecutor.Set set = intro.getSetExecutor(list, (Object)1, (Object)"foo");
        DiscoveryTest.assertTrue((String)"list property getter", (boolean)(get instanceof ListGetExecutor));
        DiscoveryTest.assertTrue((String)"list property setter", (boolean)(set instanceof ListSetExecutor));
        DiscoveryTest.assertEquals((Object)get, (Object)uber.getPropertyGet(list, (Object)1, null));
        DiscoveryTest.assertEquals((Object)set, (Object)uber.getPropertySet(list, (Object)1, (Object)"foo", null));
        DiscoveryTest.assertFalse((boolean)get.equals((AbstractExecutor)intro.getGetExecutor(list, (Object)0)));
        DiscoveryTest.assertFalse((boolean)get.equals((AbstractExecutor)intro.getSetExecutor(list, (Object)0, (Object)"foo")));
        Object bar = set.execute(list, (Object)"bar");
        DiscoveryTest.assertEquals((Object)"bar", (Object)bar);
        DiscoveryTest.assertEquals((Object)"bar", (Object)get.execute(list));
        Object quux = set.tryExecute(list, (Object)1, (Object)"quux");
        DiscoveryTest.assertEquals((Object)"quux", (Object)quux);
        DiscoveryTest.assertEquals((Object)"quux", (Object)get.execute(list));
        DiscoveryTest.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryExecute(list, (Object)"eulav", (Object)"nope"));
    }

    public void testMapIntrospection() throws Exception {
        Uberspect uber = JexlEngine.getUberspect(null);
        Introspector intro = (Introspector)uber;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", "MAP");
        map.put("eulav", "PAM");
        AbstractExecutor.Get get = intro.getGetExecutor(map, (Object)"value");
        AbstractExecutor.Set set = intro.getSetExecutor(map, (Object)"value", (Object)"foo");
        DiscoveryTest.assertTrue((String)"map property getter", (boolean)(get instanceof MapGetExecutor));
        DiscoveryTest.assertTrue((String)"map property setter", (boolean)(set instanceof MapSetExecutor));
        DiscoveryTest.assertEquals((Object)get, (Object)uber.getPropertyGet(map, (Object)"value", null));
        DiscoveryTest.assertEquals((Object)set, (Object)uber.getPropertySet(map, (Object)"value", (Object)"foo", null));
        DiscoveryTest.assertFalse((boolean)get.equals((AbstractExecutor)intro.getGetExecutor(map, (Object)"eulav")));
        DiscoveryTest.assertFalse((boolean)get.equals((AbstractExecutor)intro.getSetExecutor(map, (Object)"eulav", (Object)"foo")));
        Object bar = set.execute(map, (Object)"bar");
        DiscoveryTest.assertEquals((Object)"bar", (Object)bar);
        DiscoveryTest.assertEquals((Object)"bar", (Object)get.execute(map));
        Object quux = set.tryExecute(map, (Object)"value", (Object)"quux");
        DiscoveryTest.assertEquals((Object)"quux", (Object)quux);
        DiscoveryTest.assertEquals((Object)"quux", (Object)get.execute(map));
        DiscoveryTest.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryExecute(map, (Object)1, (Object)"nope"));
    }

    public static class Bean {
        private String value;
        private String eulav;
        private boolean flag;

        public Bean(String v, String e) {
            this.value = v;
            this.eulav = e;
            this.flag = true;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
            this.value = v;
        }

        public String getEulav() {
            return this.eulav;
        }

        public void setEulav(String v) {
            this.eulav = v;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean f) {
            this.flag = f;
        }
    }

    public static class Duck {
        private String value;
        private String eulav;

        public Duck(String v, String e) {
            this.value = v;
            this.eulav = e;
        }

        public String get(String prop) {
            if ("value".equals(prop)) {
                return this.value;
            }
            if ("eulav".equals(prop)) {
                return this.eulav;
            }
            return "no such property";
        }

        public void set(String prop, String v) {
            if ("value".equals(prop)) {
                this.value = v;
            } else if ("eulav".equals(prop)) {
                this.eulav = v;
            }
        }
    }
}

