/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class PublicFieldsTest
extends JexlTestCase {
    private static final String LOWER42 = "fourty-two";
    private static final String UPPER42 = "FOURTY-TWO";
    private Struct pub;
    private JexlContext ctxt;

    public PublicFieldsTest() {
        super(PublicFieldsTest.createEngine(false));
    }

    public void setUp() {
        this.pub = new Struct();
        this.ctxt = new MapContext();
        this.ctxt.set("pub", (Object)this.pub);
    }

    public void testGetInt() throws Exception {
        Expression get = this.JEXL.createExpression("pub.anInt");
        PublicFieldsTest.assertEquals((Object)42, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "anInt", (Object)-42);
        PublicFieldsTest.assertEquals((Object)-42, (Object)get.evaluate(this.ctxt));
    }

    public void testSetInt() throws Exception {
        Expression set = this.JEXL.createExpression("pub.anInt = value");
        this.ctxt.set("value", (Object)-42);
        PublicFieldsTest.assertEquals((Object)-42, (Object)set.evaluate(this.ctxt));
        PublicFieldsTest.assertEquals((Object)-42, (Object)this.JEXL.getProperty((Object)this.pub, "anInt"));
        this.ctxt.set("value", (Object)42);
        PublicFieldsTest.assertEquals((Object)42, (Object)set.evaluate(this.ctxt));
        PublicFieldsTest.assertEquals((Object)42, (Object)this.JEXL.getProperty((Object)this.pub, "anInt"));
        try {
            this.ctxt.set("value", (Object)UPPER42);
            PublicFieldsTest.assertEquals(null, (Object)set.evaluate(this.ctxt));
            PublicFieldsTest.fail((String)"should have thrown");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    public void testGetString() throws Exception {
        Expression get = this.JEXL.createExpression("pub.aString");
        PublicFieldsTest.assertEquals((Object)LOWER42, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "aString", (Object)UPPER42);
        PublicFieldsTest.assertEquals((Object)UPPER42, (Object)get.evaluate(this.ctxt));
    }

    public void testSetString() throws Exception {
        Expression set = this.JEXL.createExpression("pub.aString = value");
        this.ctxt.set("value", (Object)UPPER42);
        PublicFieldsTest.assertEquals((Object)UPPER42, (Object)set.evaluate(this.ctxt));
        PublicFieldsTest.assertEquals((Object)UPPER42, (Object)this.JEXL.getProperty((Object)this.pub, "aString"));
        this.ctxt.set("value", (Object)LOWER42);
        PublicFieldsTest.assertEquals((Object)LOWER42, (Object)set.evaluate(this.ctxt));
        PublicFieldsTest.assertEquals((Object)LOWER42, (Object)this.JEXL.getProperty((Object)this.pub, "aString"));
    }

    public void testGetInnerDouble() throws Exception {
        Expression get = this.JEXL.createExpression("pub.inner.aDouble");
        PublicFieldsTest.assertEquals((Object)42.0, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "inner.aDouble", (Object)-42);
        PublicFieldsTest.assertEquals((Object)-42.0, (Object)get.evaluate(this.ctxt));
    }

    public void testSetInnerDouble() throws Exception {
        Expression set = this.JEXL.createExpression("pub.inner.aDouble = value");
        this.ctxt.set("value", (Object)-42.0);
        PublicFieldsTest.assertEquals((Object)-42.0, (Object)set.evaluate(this.ctxt));
        PublicFieldsTest.assertEquals((Object)-42.0, (Object)this.JEXL.getProperty((Object)this.pub, "inner.aDouble"));
        this.ctxt.set("value", (Object)42.0);
        PublicFieldsTest.assertEquals((Object)42.0, (Object)set.evaluate(this.ctxt));
        PublicFieldsTest.assertEquals((Object)42.0, (Object)this.JEXL.getProperty((Object)this.pub, "inner.aDouble"));
        try {
            this.ctxt.set("value", (Object)UPPER42);
            PublicFieldsTest.assertEquals(null, (Object)set.evaluate(this.ctxt));
            PublicFieldsTest.fail((String)"should have thrown");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    public static class Struct {
        public Inner inner = new Inner();
        public int anInt = 42;
        public String aString = "fourty-two";
    }

    public static class Inner {
        public double aDouble = 42.0;
    }
}

