/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.struct;

import junit.framework.TestCase;
import org.apache.commons.jcs3.utils.struct.LRUMap;

public class LRUMapPerformanceTest
extends TestCase {
    float ratioPut;
    float ratioGet;
    float targetPut = 1.2f;
    float targetGet = 0.5f;
    int loops = 20;
    int tries = 100000;

    public void testSimpleLoad() throws Exception {
        this.doWork();
        LRUMapPerformanceTest.assertTrue((this.ratioPut < this.targetPut ? 1 : 0) != 0);
        LRUMapPerformanceTest.assertTrue((this.ratioGet < this.targetGet ? 1 : 0) != 0);
    }

    public void doWork() {
        long start = 0L;
        long end = 0L;
        long time = 0L;
        float tPer = 0.0f;
        long putTotalJCS = 0L;
        long getTotalJCS = 0L;
        long putTotalHashtable = 0L;
        long getTotalHashtable = 0L;
        String name = "LRUMap";
        String cache2Name = "";
        try {
            LRUMap cache = new LRUMap(this.tries);
            for (int j = 0; j < this.loops; ++j) {
                int i;
                int i2;
                name = "JCS      ";
                start = System.currentTimeMillis();
                for (i2 = 0; i2 < this.tries; ++i2) {
                    cache.put((Object)("key:" + i2), (Object)("data" + i2));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalJCS += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i2 = 0; i2 < this.tries; ++i2) {
                    cache.get((Object)("key:" + i2));
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalJCS += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                cache2Name = "LRUMap (commons)";
                org.apache.commons.collections4.map.LRUMap cache2 = new org.apache.commons.collections4.map.LRUMap(this.tries);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cache2.put("key:" + i, "data" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalHashtable += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(cache2Name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cache2.get("key:" + i);
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalHashtable += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(cache2Name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                System.out.println("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(e);
        }
        long putAvJCS = putTotalJCS / (long)this.loops;
        long getAvJCS = getTotalJCS / (long)this.loops;
        long putAvHashtable = putTotalHashtable / (long)this.loops;
        long getAvHashtable = getTotalHashtable / (long)this.loops;
        System.out.println("Finished " + this.loops + " loops of " + this.tries + " gets and puts");
        System.out.println("\n");
        System.out.println("Put average for LRUMap       = " + putAvJCS);
        System.out.println("Put average for " + cache2Name + " = " + putAvHashtable);
        this.ratioPut = Float.intBitsToFloat((int)putAvJCS) / Float.intBitsToFloat((int)putAvHashtable);
        System.out.println(name + " puts took " + this.ratioPut + " times the " + cache2Name + ", the goal is <" + this.targetPut + "x");
        System.out.println("\n");
        System.out.println("Get average for LRUMap       = " + getAvJCS);
        System.out.println("Get average for " + cache2Name + " = " + getAvHashtable);
        this.ratioGet = Float.intBitsToFloat((int)getAvJCS) / Float.intBitsToFloat((int)getAvHashtable);
        System.out.println(name + " gets took " + this.ratioGet + " times the " + cache2Name + ", the goal is <" + this.targetGet + "x");
    }
}

