/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import org.apache.commons.io.input.BrokenInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class BrokenInputStreamTest {
    BrokenInputStreamTest() {
    }

    private static BrokenInputStream createBrokenInputStream(Throwable exception) {
        if (exception instanceof IOException) {
            return new BrokenInputStream((IOException)exception);
        }
        return new BrokenInputStream(exception);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testAvailable(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenInputStream stream = BrokenInputStreamTest.createBrokenInputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.available()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testClose(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenInputStream stream = BrokenInputStreamTest.createBrokenInputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.close()));
    }

    @Test
    void testInstance() {
        Assertions.assertNotNull((Object)BrokenInputStream.INSTANCE);
    }

    @Test
    void testIO469() throws Throwable {
        BrokenInputStream in = new BrokenInputStream();
        Throwable localThrowable2 = null;
        try {
            try {
                in.read();
            }
            catch (Throwable localThrowable1) {
                localThrowable2 = localThrowable1;
                throw localThrowable1;
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable x2) {
                    localThrowable2.addSuppressed(x2);
                }
            }
        }
        catch (IOException expected) {
            Throwable[] suppressed = expected.getSuppressed();
            Assertions.assertEquals((int)1, (int)suppressed.length);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testRead(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenInputStream stream = BrokenInputStreamTest.createBrokenInputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.read()));
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.read(new byte[1])));
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.read(new byte[1], 0, 1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testReset(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenInputStream stream = BrokenInputStreamTest.createBrokenInputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.reset()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.BrokenTestFactories#parameters"})
    void testSkip(Class<Exception> clazz) throws Exception {
        Throwable exception = clazz.newInstance();
        BrokenInputStream stream = BrokenInputStreamTest.createBrokenInputStream(exception);
        Assertions.assertEquals((Object)exception, (Object)Assertions.assertThrows(clazz, () -> stream.skip(1L)));
    }

    @Test
    void testTryWithResources() {
        IOException thrown = (IOException)Assertions.assertThrows(IOException.class, () -> {
            try (BrokenInputStream newStream = new BrokenInputStream();){
                newStream.read();
            }
        });
        Assertions.assertEquals((Object)"Broken input stream", (Object)thrown.getMessage());
        Throwable[] suppressed = thrown.getSuppressed();
        Assertions.assertEquals((int)1, (int)suppressed.length);
        Assertions.assertEquals(IOException.class, suppressed[0].getClass());
        Assertions.assertEquals((Object)"Broken input stream", (Object)suppressed[0].getMessage());
    }
}

