/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DeletingPathVisitorTest
extends AbstractTempDirTest {
    private static final String ARGS = "org.apache.commons.io.file.TestArguments#";

    DeletingPathVisitorTest() {
    }

    private void applyDeleteEmptyDirectory(DeletingPathVisitor visitor) throws IOException {
        Files.walkFileTree(this.tempDirPath, (FileVisitor<? super Path>)visitor);
        CounterAssertions.assertCounts(1L, 0L, 0L, (CountingPathVisitor)visitor);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.file.TestArguments#deletingPathVisitors"})
    void testDeleteEmptyDirectory(DeletingPathVisitor visitor) throws IOException {
        this.applyDeleteEmptyDirectory(visitor);
        Files.deleteIfExists(this.tempDirPath);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.file.TestArguments#pathCounters"})
    void testDeleteEmptyDirectoryNullCtorArg(Counters.PathCounters pathCounters) throws IOException {
        this.applyDeleteEmptyDirectory(new DeletingPathVisitor(pathCounters, (String[])null));
        Files.deleteIfExists(this.tempDirPath);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.file.TestArguments#deletingPathVisitors"})
    void testDeleteFolders1FileSize0(DeletingPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.file.TestArguments#deletingPathVisitors"})
    void testDeleteFolders1FileSize1(DeletingPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.file.TestArguments#pathCounters"})
    void testDeleteFolders1FileSize1Skip(Counters.PathCounters pathCounters) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        String skipFileName = "file-size-1.bin";
        DeletingPathVisitor visitor = new DeletingPathVisitor(pathCounters, new String[]{"file-size-1.bin"});
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDirPath));
        Path skippedFile = this.tempDirPath.resolve("file-size-1.bin");
        Assertions.assertTrue((boolean)Files.exists(skippedFile, new LinkOption[0]));
        Files.delete(skippedFile);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.file.TestArguments#deletingPathVisitors"})
    void testDeleteFolders2FileSize2(DeletingPathVisitor visitor) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(3L, 2L, 2L, (CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)visitor, (Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    void testEqualsHashCode() {
        DeletingPathVisitor visitor0 = DeletingPathVisitor.withLongCounters();
        DeletingPathVisitor visitor1 = DeletingPathVisitor.withLongCounters();
        Assertions.assertEquals((Object)visitor0, (Object)visitor0);
        Assertions.assertEquals((Object)visitor0, (Object)visitor1);
        Assertions.assertEquals((Object)visitor1, (Object)visitor0);
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor0.hashCode());
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor1.hashCode());
        Assertions.assertEquals((int)visitor1.hashCode(), (int)visitor0.hashCode());
        visitor0.getPathCounters().getByteCounter().increment();
        Assertions.assertEquals((Object)visitor0, (Object)visitor0);
        Assertions.assertNotEquals((Object)visitor0, (Object)visitor1);
        Assertions.assertNotEquals((Object)visitor1, (Object)visitor0);
        Assertions.assertEquals((int)visitor0.hashCode(), (int)visitor0.hashCode());
        Assertions.assertNotEquals((int)visitor0.hashCode(), (int)visitor1.hashCode());
        Assertions.assertNotEquals((int)visitor1.hashCode(), (int)visitor0.hashCode());
    }

    @Test
    void testIO850DirectoriesAndFiles() throws IOException {
        Path rootDir = Files.createDirectory(this.managedTempDirPath.resolve("IO850"), new FileAttribute[0]);
        DeletingPathVisitorTest.createTempSymbolicLinkedRelativeDir(rootDir);
        Path targetDir = rootDir.resolve("subdir");
        Path symlinkDir = rootDir.resolve("symlinked-dir");
        Files.write(targetDir.resolve("file0.txt"), "Hello".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path subDir0 = Files.createDirectory(targetDir.resolve("subDir0"), new FileAttribute[0]);
        Files.write(subDir0.resolve("file1.txt"), "Hello".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        DeletingPathVisitor visitor = DeletingPathVisitor.withLongCounters();
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)visitor);
        Assertions.assertFalse((boolean)Files.exists(targetDir, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(symlinkDir, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(rootDir, new LinkOption[0]));
        Assertions.assertTrue((visitor.getPathCounters().getDirectoryCounter().get() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((visitor.getPathCounters().getFileCounter().get() > 0L ? 1 : 0) != 0);
    }

    @Test
    void testIO850DirectoriesOnly() throws IOException {
        Path rootDir = Files.createDirectory(this.managedTempDirPath.resolve("IO850"), new FileAttribute[0]);
        DeletingPathVisitorTest.createTempSymbolicLinkedRelativeDir(rootDir);
        Path targetDir = rootDir.resolve("subdir");
        Path symlinkDir = rootDir.resolve("symlinked-dir");
        DeletingPathVisitor visitor = DeletingPathVisitor.withLongCounters();
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)visitor);
        Assertions.assertFalse((boolean)Files.exists(targetDir, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(symlinkDir, new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(rootDir, new LinkOption[0]));
        Assertions.assertTrue((visitor.getPathCounters().getDirectoryCounter().get() > 0L ? 1 : 0) != 0);
    }
}

