/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.geometry.euclidean.AbstractBounds;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.shape.Parallelogram;
import org.apache.commons.numbers.core.Precision;

public final class Bounds2D
extends AbstractBounds<Vector2D, Bounds2D> {
    private Bounds2D(Vector2D min, Vector2D max) {
        super(min, max);
    }

    @Override
    public boolean hasSize(Precision.DoubleEquivalence precision) {
        Vector2D diag = (Vector2D)this.getDiagonal();
        return !precision.eqZero(diag.getX()) && !precision.eqZero(diag.getY());
    }

    @Override
    public boolean contains(Vector2D pt) {
        double x = pt.getX();
        double y = pt.getY();
        Vector2D min = (Vector2D)this.getMin();
        Vector2D max = (Vector2D)this.getMax();
        return x >= min.getX() && x <= max.getX() && y >= min.getY() && y <= max.getY();
    }

    @Override
    public boolean contains(Vector2D pt, Precision.DoubleEquivalence precision) {
        double x = pt.getX();
        double y = pt.getY();
        Vector2D min = (Vector2D)this.getMin();
        Vector2D max = (Vector2D)this.getMax();
        return precision.gte(x, min.getX()) && precision.lte(x, max.getX()) && precision.gte(y, min.getY()) && precision.lte(y, max.getY());
    }

    @Override
    public boolean intersects(Bounds2D other) {
        Vector2D aMin = (Vector2D)this.getMin();
        Vector2D aMax = (Vector2D)this.getMax();
        Vector2D bMin = (Vector2D)other.getMin();
        Vector2D bMax = (Vector2D)other.getMax();
        return aMin.getX() <= bMax.getX() && aMax.getX() >= bMin.getX() && aMin.getY() <= bMax.getY() && aMax.getY() >= bMin.getY();
    }

    @Override
    public Bounds2D intersection(Bounds2D other) {
        if (this.intersects(other)) {
            Vector2D aMin = (Vector2D)this.getMin();
            Vector2D aMax = (Vector2D)this.getMax();
            Vector2D bMin = (Vector2D)other.getMin();
            Vector2D bMax = (Vector2D)other.getMax();
            double minX = Math.max(aMin.getX(), bMin.getX());
            double minY = Math.max(aMin.getY(), bMin.getY());
            double maxX = Math.min(aMax.getX(), bMax.getX());
            double maxY = Math.min(aMax.getY(), bMax.getY());
            return new Bounds2D(Vector2D.of(minX, minY), Vector2D.of(maxX, maxY));
        }
        return null;
    }

    public Parallelogram toRegion(Precision.DoubleEquivalence precision) {
        return Parallelogram.axisAligned((Vector2D)this.getMin(), (Vector2D)this.getMax(), precision);
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Bounds2D)) {
            return false;
        }
        Bounds2D other = (Bounds2D)obj;
        return ((Vector2D)this.getMin()).equals(other.getMin()) && ((Vector2D)this.getMax()).equals(other.getMax());
    }

    public static Bounds2D from(Vector2D first, Vector2D ... more) {
        Builder builder = Bounds2D.builder();
        builder.add(first);
        builder.addAll(Arrays.asList(more));
        return builder.build();
    }

    public static Bounds2D from(Iterable<Vector2D> points) {
        Builder builder = Bounds2D.builder();
        builder.addAll(points);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private double minX = Double.POSITIVE_INFINITY;
        private double minY = Double.POSITIVE_INFINITY;
        private double maxX = Double.NEGATIVE_INFINITY;
        private double maxY = Double.NEGATIVE_INFINITY;

        private Builder() {
        }

        public Builder add(Vector2D pt) {
            double x = pt.getX();
            double y = pt.getY();
            this.minX = Math.min(x, this.minX);
            this.minY = Math.min(y, this.minY);
            this.maxX = Math.max(x, this.maxX);
            this.maxY = Math.max(y, this.maxY);
            return this;
        }

        public Builder addAll(Iterable<? extends Vector2D> pts) {
            for (Vector2D vector2D : pts) {
                this.add(vector2D);
            }
            return this;
        }

        public Builder add(Bounds2D bounds) {
            this.add((Vector2D)bounds.getMin());
            this.add((Vector2D)bounds.getMax());
            return this;
        }

        public boolean hasBounds() {
            return Double.isFinite(this.minX) && Double.isFinite(this.minY) && Double.isFinite(this.maxX) && Double.isFinite(this.maxY);
        }

        public Bounds2D build() {
            Vector2D min = Vector2D.of(this.minX, this.minY);
            Vector2D max = Vector2D.of(this.maxX, this.maxY);
            if (!this.hasBounds()) {
                if (Double.isInfinite(this.minX) && this.minX > 0.0 && Double.isInfinite(this.maxX) && this.maxX < 0.0) {
                    throw new IllegalStateException("Cannot construct bounds: no points given");
                }
                throw new IllegalStateException("Invalid bounds: min= " + min + ", max= " + max);
            }
            return new Bounds2D(min, max);
        }
    }
}

