/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.mail2.jakarta.DataSourceResolver;
import org.apache.commons.mail2.jakarta.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail2.jakarta.resolver.DataSourceUrlResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSourceUrlResolverTest
extends AbstractDataSourceResolverTest {
    @Test
    public void testResolvingFilesLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new File("./src/test/resources").toURI().toURL(), true);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length);
        Assertions.assertNull((Object)dataSourceResolver.resolve("./images/does-not-exist.gif"));
        Assertions.assertNull((Object)dataSourceResolver.resolve("/images/asf_logo_wide.gif"));
    }

    @Test
    public void testResolvingHttpLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("https://www.apache.org"), true);
        Assertions.assertTrue((this.toByteArray(dataSourceResolver.resolve("https://www.apache.org/images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.toByteArray(dataSourceResolver.resolve("images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.toByteArray(dataSourceResolver.resolve("./images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/feather-small.gif")).length > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testResolvingHttpLenientHost() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("http://does.not.exist"), true);
        Assertions.assertNull((Object)this.toByteArray(dataSourceResolver.resolve("/images/does-not-exist.gif")));
    }

    @Test
    public void testResolvingHttpNonLenient() throws Exception {
        DataSourceUrlResolver dataSourceResolver = new DataSourceUrlResolver(new URL("http://does.not.exist"), false);
        Assertions.assertThrows(IOException.class, () -> DataSourceUrlResolverTest.lambda$testResolvingHttpNonLenient$0((DataSourceResolver)dataSourceResolver));
        Assertions.assertThrows(IOException.class, () -> DataSourceUrlResolverTest.lambda$testResolvingHttpNonLenient$1((DataSourceResolver)dataSourceResolver));
    }

    private static /* synthetic */ void lambda$testResolvingHttpNonLenient$1(DataSourceResolver dataSourceResolver) throws Throwable {
        dataSourceResolver.resolve("images/does-not-exist.gif");
    }

    private static /* synthetic */ void lambda$testResolvingHttpNonLenient$0(DataSourceResolver dataSourceResolver) throws Throwable {
        dataSourceResolver.resolve("images/asf_logo_wide.gif");
    }
}

