/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterStatement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegatingStatement {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingStatement stmt = null;
    private Statement delegateStmt = null;

    @Before
    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.delegateStmt = new TesterStatement(this.delegateConn);
        this.conn = new DelegatingConnection(this.delegateConn);
        this.stmt = new DelegatingStatement(this.conn, this.delegateStmt);
    }

    @Test
    public void testExecuteQueryReturnsNull() throws Exception {
        Assert.assertNull((Object)this.stmt.executeQuery("null"));
    }

    @Test
    public void testGetDelegate() throws Exception {
        Assert.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }

    @Test
    public void testCheckOpen() throws Exception {
        this.stmt.checkOpen();
        this.stmt.close();
        try {
            this.stmt.checkOpen();
            Assert.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testIsWrapperFor() throws Exception {
        TesterConnection tstConn = new TesterConnection("test", "test");
        TesterStatementNonWrapping tstStmt = new TesterStatementNonWrapping(tstConn);
        DelegatingConnection dconn = new DelegatingConnection((Connection)tstConn);
        DelegatingStatement stamt = new DelegatingStatement(dconn, (Statement)tstStmt);
        Class<?> stmtProxyClass = Proxy.getProxyClass(this.getClass().getClassLoader(), Statement.class);
        Assert.assertTrue((boolean)stamt.isWrapperFor(DelegatingStatement.class));
        Assert.assertTrue((boolean)stamt.isWrapperFor(TesterStatement.class));
        Assert.assertFalse((boolean)stamt.isWrapperFor(stmtProxyClass));
        stamt.close();
    }

    private static class TesterStatementNonWrapping
    extends TesterStatement {
        public TesterStatementNonWrapping(Connection conn) {
            super(conn);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

