/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.AbstractOpenSslFeedbackCipher;
import org.apache.commons.crypto.cipher.OpenSslCommonMode;
import org.apache.commons.crypto.cipher.OpenSslGaloisCounterMode;
import org.apache.commons.crypto.cipher.OpenSslNative;
import org.apache.commons.crypto.utils.Transformation;
import org.apache.commons.crypto.utils.Utils;

final class OpenSsl {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 0;
    private static final Throwable loadingFailureReason;
    private final AbstractOpenSslFeedbackCipher opensslBlockCipher;

    static {
        block6: {
            Throwable loadingFailure = null;
            try {
                try {
                    if (Crypto.isNativeCodeLoaded()) {
                        OpenSslNative.initIDs();
                        break block6;
                    }
                    loadingFailure = Crypto.getLoadingError();
                }
                catch (Exception | UnsatisfiedLinkError t) {
                    loadingFailureReason = loadingFailure = t;
                }
            }
            finally {
                loadingFailureReason = loadingFailure;
            }
        }
    }

    public static OpenSsl getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (loadingFailureReason != null) {
            throw new IllegalStateException(loadingFailureReason);
        }
        Transformation transform = Transformation.parse(transformation);
        int algorithmMode = AlgorithmMode.get(transform.getAlgorithm(), transform.getMode());
        int padding = transform.getPadding().ordinal();
        long context = OpenSslNative.initContext(algorithmMode, padding);
        return new OpenSsl(context, algorithmMode, padding);
    }

    public static Throwable getLoadingFailureReason() {
        return loadingFailureReason;
    }

    private OpenSsl(long context, int algorithm, int padding) {
        this.opensslBlockCipher = algorithm == AlgorithmMode.AES_GCM.ordinal() ? new OpenSslGaloisCounterMode(context, algorithm, padding) : new OpenSslCommonMode(context, algorithm, padding);
    }

    public void clean() {
        if (this.opensslBlockCipher != null) {
            this.opensslBlockCipher.clean();
        }
    }

    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.opensslBlockCipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    public int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        Utils.checkArgument(output.isDirect(), "Direct buffer is required.");
        return this.opensslBlockCipher.doFinal(input, output);
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    public void init(int mode, byte[] key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.opensslBlockCipher.init(mode, key, params);
    }

    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.opensslBlockCipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    public int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        Utils.checkArgument(input.isDirect() && output.isDirect(), "Direct buffers are required.");
        return this.opensslBlockCipher.update(input, output);
    }

    public void updateAAD(byte[] aad) {
        this.opensslBlockCipher.updateAAD(aad);
    }

    private static enum AlgorithmMode {
        AES_CTR,
        AES_CBC,
        AES_GCM;


        static int get(String algorithm, String mode) throws NoSuchAlgorithmException {
            try {
                return AlgorithmMode.valueOf(String.valueOf(algorithm) + "_" + mode).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Algorithm not supported: " + algorithm + " and mode: " + mode);
            }
        }
    }
}

