/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.junit.Assert;

public class ConfigurationErrorListenerImpl
implements ConfigurationErrorListener {
    private ConfigurationErrorEvent event;
    private int errorCount;

    public void configurationError(ConfigurationErrorEvent event) {
        this.event = event;
        ++this.errorCount;
    }

    public ConfigurationErrorEvent getLastEvent() {
        return this.event;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void verify() {
        Assert.assertEquals((String)"Error events received", (long)0L, (long)this.errorCount);
    }

    public void verify(int type, String propName, Object propValue) {
        Assert.assertEquals((String)"Wrong number of error events", (long)1L, (long)this.errorCount);
        Assert.assertEquals((String)"Wrong event type", (long)type, (long)this.event.getType());
        Assert.assertTrue((String)"Wrong property name", (boolean)(propName == null ? this.event.getPropertyName() == null : propName.equals(this.event.getPropertyName())));
        Assert.assertTrue((String)"Wrong property value", (boolean)(propValue == null ? this.event.getPropertyValue() == null : propValue.equals(this.event.getPropertyValue())));
    }
}

