/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.CodecEncoding;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PopulationCodec;
import org.apache.commons.compress.harmony.pack200.RunCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CodecEncodingTest {
    CodecEncodingTest() {
    }

    static Stream<Arguments> arbitraryCodec() {
        return Stream.of(Arguments.of((Object[])new Object[]{"(1,256)", new byte[]{0, -1}}), Arguments.of((Object[])new Object[]{"(5,128,2,1)", new byte[]{37, 127}}), Arguments.of((Object[])new Object[]{"(2,128,1,1)", new byte[]{11, 127}}));
    }

    static Stream<Arguments> canonicalEncodings() {
        return Stream.of(Arguments.of((Object[])new Object[]{1, "(1,256)"}), Arguments.of((Object[])new Object[]{2, "(1,256,1)"}), Arguments.of((Object[])new Object[]{3, "(1,256,0,1)"}), Arguments.of((Object[])new Object[]{4, "(1,256,1,1)"}), Arguments.of((Object[])new Object[]{5, "(2,256)"}), Arguments.of((Object[])new Object[]{6, "(2,256,1)"}), Arguments.of((Object[])new Object[]{7, "(2,256,0,1)"}), Arguments.of((Object[])new Object[]{8, "(2,256,1,1)"}), Arguments.of((Object[])new Object[]{9, "(3,256)"}), Arguments.of((Object[])new Object[]{10, "(3,256,1)"}), Arguments.of((Object[])new Object[]{11, "(3,256,0,1)"}), Arguments.of((Object[])new Object[]{12, "(3,256,1,1)"}), Arguments.of((Object[])new Object[]{13, "(4,256)"}), Arguments.of((Object[])new Object[]{14, "(4,256,1)"}), Arguments.of((Object[])new Object[]{15, "(4,256,0,1)"}), Arguments.of((Object[])new Object[]{16, "(4,256,1,1)"}), Arguments.of((Object[])new Object[]{17, "(5,4)"}), Arguments.of((Object[])new Object[]{18, "(5,4,1)"}), Arguments.of((Object[])new Object[]{19, "(5,4,2)"}), Arguments.of((Object[])new Object[]{20, "(5,16)"}), Arguments.of((Object[])new Object[]{21, "(5,16,1)"}), Arguments.of((Object[])new Object[]{22, "(5,16,2)"}), Arguments.of((Object[])new Object[]{23, "(5,32)"}), Arguments.of((Object[])new Object[]{24, "(5,32,1)"}), Arguments.of((Object[])new Object[]{25, "(5,32,2)"}), Arguments.of((Object[])new Object[]{26, "(5,64)"}), Arguments.of((Object[])new Object[]{27, "(5,64,1)"}), Arguments.of((Object[])new Object[]{28, "(5,64,2)"}), Arguments.of((Object[])new Object[]{29, "(5,128)"}), Arguments.of((Object[])new Object[]{30, "(5,128,1)"}), Arguments.of((Object[])new Object[]{31, "(5,128,2)"}), Arguments.of((Object[])new Object[]{32, "(5,4,0,1)"}), Arguments.of((Object[])new Object[]{33, "(5,4,1,1)"}), Arguments.of((Object[])new Object[]{34, "(5,4,2,1)"}), Arguments.of((Object[])new Object[]{35, "(5,16,0,1)"}), Arguments.of((Object[])new Object[]{36, "(5,16,1,1)"}), Arguments.of((Object[])new Object[]{37, "(5,16,2,1)"}), Arguments.of((Object[])new Object[]{38, "(5,32,0,1)"}), Arguments.of((Object[])new Object[]{39, "(5,32,1,1)"}), Arguments.of((Object[])new Object[]{40, "(5,32,2,1)"}), Arguments.of((Object[])new Object[]{41, "(5,64,0,1)"}), Arguments.of((Object[])new Object[]{42, "(5,64,1,1)"}), Arguments.of((Object[])new Object[]{43, "(5,64,2,1)"}), Arguments.of((Object[])new Object[]{44, "(5,128,0,1)"}), Arguments.of((Object[])new Object[]{45, "(5,128,1,1)"}), Arguments.of((Object[])new Object[]{46, "(5,128,2,1)"}), Arguments.of((Object[])new Object[]{47, "(2,192)"}), Arguments.of((Object[])new Object[]{48, "(2,224)"}), Arguments.of((Object[])new Object[]{49, "(2,240)"}), Arguments.of((Object[])new Object[]{50, "(2,248)"}), Arguments.of((Object[])new Object[]{51, "(2,252)"}), Arguments.of((Object[])new Object[]{52, "(2,8,0,1)"}), Arguments.of((Object[])new Object[]{53, "(2,8,1,1)"}), Arguments.of((Object[])new Object[]{54, "(2,16,0,1)"}), Arguments.of((Object[])new Object[]{55, "(2,16,1,1)"}), Arguments.of((Object[])new Object[]{56, "(2,32,0,1)"}), Arguments.of((Object[])new Object[]{57, "(2,32,1,1)"}), Arguments.of((Object[])new Object[]{58, "(2,64,0,1)"}), Arguments.of((Object[])new Object[]{59, "(2,64,1,1)"}), Arguments.of((Object[])new Object[]{60, "(2,128,0,1)"}), Arguments.of((Object[])new Object[]{61, "(2,128,1,1)"}), Arguments.of((Object[])new Object[]{62, "(2,192,0,1)"}), Arguments.of((Object[])new Object[]{63, "(2,192,1,1)"}), Arguments.of((Object[])new Object[]{64, "(2,224,0,1)"}), Arguments.of((Object[])new Object[]{65, "(2,224,1,1)"}), Arguments.of((Object[])new Object[]{66, "(2,240,0,1)"}), Arguments.of((Object[])new Object[]{67, "(2,240,1,1)"}), Arguments.of((Object[])new Object[]{68, "(2,248,0,1)"}), Arguments.of((Object[])new Object[]{69, "(2,248,1,1)"}), Arguments.of((Object[])new Object[]{70, "(3,192)"}), Arguments.of((Object[])new Object[]{71, "(3,224)"}), Arguments.of((Object[])new Object[]{72, "(3,240)"}), Arguments.of((Object[])new Object[]{73, "(3,248)"}), Arguments.of((Object[])new Object[]{74, "(3,252)"}), Arguments.of((Object[])new Object[]{75, "(3,8,0,1)"}), Arguments.of((Object[])new Object[]{76, "(3,8,1,1)"}), Arguments.of((Object[])new Object[]{77, "(3,16,0,1)"}), Arguments.of((Object[])new Object[]{78, "(3,16,1,1)"}), Arguments.of((Object[])new Object[]{79, "(3,32,0,1)"}), Arguments.of((Object[])new Object[]{80, "(3,32,1,1)"}), Arguments.of((Object[])new Object[]{81, "(3,64,0,1)"}), Arguments.of((Object[])new Object[]{82, "(3,64,1,1)"}), Arguments.of((Object[])new Object[]{83, "(3,128,0,1)"}), Arguments.of((Object[])new Object[]{84, "(3,128,1,1)"}), Arguments.of((Object[])new Object[]{85, "(3,192,0,1)"}), Arguments.of((Object[])new Object[]{86, "(3,192,1,1)"}), Arguments.of((Object[])new Object[]{87, "(3,224,0,1)"}), Arguments.of((Object[])new Object[]{88, "(3,224,1,1)"}), Arguments.of((Object[])new Object[]{89, "(3,240,0,1)"}), Arguments.of((Object[])new Object[]{90, "(3,240,1,1)"}), Arguments.of((Object[])new Object[]{91, "(3,248,0,1)"}), Arguments.of((Object[])new Object[]{92, "(3,248,1,1)"}), Arguments.of((Object[])new Object[]{93, "(4,192)"}), Arguments.of((Object[])new Object[]{94, "(4,224)"}), Arguments.of((Object[])new Object[]{95, "(4,240)"}), Arguments.of((Object[])new Object[]{96, "(4,248)"}), Arguments.of((Object[])new Object[]{97, "(4,252)"}), Arguments.of((Object[])new Object[]{98, "(4,8,0,1)"}), Arguments.of((Object[])new Object[]{99, "(4,8,1,1)"}), Arguments.of((Object[])new Object[]{100, "(4,16,0,1)"}), Arguments.of((Object[])new Object[]{101, "(4,16,1,1)"}), Arguments.of((Object[])new Object[]{102, "(4,32,0,1)"}), Arguments.of((Object[])new Object[]{103, "(4,32,1,1)"}), Arguments.of((Object[])new Object[]{104, "(4,64,0,1)"}), Arguments.of((Object[])new Object[]{105, "(4,64,1,1)"}), Arguments.of((Object[])new Object[]{106, "(4,128,0,1)"}), Arguments.of((Object[])new Object[]{107, "(4,128,1,1)"}), Arguments.of((Object[])new Object[]{108, "(4,192,0,1)"}), Arguments.of((Object[])new Object[]{109, "(4,192,1,1)"}), Arguments.of((Object[])new Object[]{110, "(4,224,0,1)"}), Arguments.of((Object[])new Object[]{111, "(4,224,1,1)"}), Arguments.of((Object[])new Object[]{112, "(4,240,0,1)"}), Arguments.of((Object[])new Object[]{113, "(4,240,1,1)"}), Arguments.of((Object[])new Object[]{114, "(4,248,0,1)"}), Arguments.of((Object[])new Object[]{115, "(4,248,1,1)"}));
    }

    static Stream<Arguments> canonicalGetSpecifier() {
        return IntStream.range(1, 115).mapToObj(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> specifier() {
        return Stream.of(Arguments.of((Object[])new Object[]{new BHSDCodec(2, 125, 0, 1)}), Arguments.of((Object[])new Object[]{new BHSDCodec(3, 125, 2, 1)}), Arguments.of((Object[])new Object[]{new BHSDCodec(4, 125)}), Arguments.of((Object[])new Object[]{new BHSDCodec(5, 125, 2, 0)}), Arguments.of((Object[])new Object[]{new BHSDCodec(3, 5, 2, 1)}));
    }

    @ParameterizedTest
    @MethodSource(value={"arbitraryCodec"})
    void testArbitraryCodec(String expected, byte[] bytes) throws IOException, Pack200Exception {
        Assertions.assertEquals((Object)expected, (Object)CodecEncoding.getCodec((int)116, (InputStream)new ByteArrayInputStream(bytes), null).toString());
    }

    @ParameterizedTest
    @MethodSource(value={"canonicalEncodings"})
    void testCanonicalEncodings(int i, String expectedCodec) throws IOException, Pack200Exception {
        Assertions.assertEquals((Object)expectedCodec, (Object)CodecEncoding.getCodec((int)i, null, null).toString());
    }

    @ParameterizedTest
    @MethodSource(value={"canonicalGetSpecifier"})
    void testCanonicalGetSpecifier(int i) throws Pack200Exception, IOException {
        Assertions.assertEquals((int)i, (int)CodecEncoding.getSpecifier((Codec)CodecEncoding.getCodec((int)i, null, null), null)[0]);
    }

    @Test
    void testDefaultCodec() throws Pack200Exception, IOException {
        BHSDCodec defaultCodec = new BHSDCodec(2, 16, 0, 0);
        Assertions.assertEquals((Object)defaultCodec, (Object)CodecEncoding.getCodec((int)0, null, (Codec)defaultCodec));
    }

    @Test
    void testGetSpeciferForPopulationCodec() throws IOException, Pack200Exception {
        PopulationCodec populationCodec = new PopulationCodec((Codec)Codec.BYTE1, (Codec)Codec.CHAR3, (Codec)Codec.UNSIGNED5);
        int[] specifiers = CodecEncoding.getSpecifier((Codec)populationCodec, null);
        Assertions.assertTrue((specifiers[0] > 140 ? 1 : 0) != 0);
        Assertions.assertTrue((specifiers[0] < 189 ? 1 : 0) != 0);
        byte[] bytes = new byte[specifiers.length - 1];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)specifiers[i + 1];
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        PopulationCodec populationCodec2 = (PopulationCodec)CodecEncoding.getCodec((int)specifiers[0], (InputStream)in, null);
        Assertions.assertEquals((Object)populationCodec.getFavouredCodec(), (Object)populationCodec2.getFavouredCodec());
        Assertions.assertEquals((Object)populationCodec.getTokenCodec(), (Object)populationCodec2.getTokenCodec());
        Assertions.assertEquals((Object)populationCodec.getUnfavouredCodec(), (Object)populationCodec2.getUnfavouredCodec());
    }

    @Test
    void testGetSpeciferForRunCodec() throws Pack200Exception, IOException {
        int i;
        RunCodec runCodec = new RunCodec(25, (Codec)Codec.DELTA5, (Codec)Codec.BYTE1);
        int[] specifiers = CodecEncoding.getSpecifier((Codec)runCodec, null);
        Assertions.assertTrue((specifiers[0] > 116 ? 1 : 0) != 0);
        Assertions.assertTrue((specifiers[0] < 141 ? 1 : 0) != 0);
        byte[] bytes = new byte[specifiers.length - 1];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)specifiers[i2 + 1];
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        RunCodec runCodec2 = (RunCodec)CodecEncoding.getCodec((int)specifiers[0], (InputStream)in, null);
        Assertions.assertEquals((int)runCodec.getK(), (int)runCodec2.getK());
        Assertions.assertEquals((Object)runCodec.getACodec(), (Object)runCodec2.getACodec());
        Assertions.assertEquals((Object)runCodec.getBCodec(), (Object)runCodec2.getBCodec());
        runCodec = new RunCodec(4096, (Codec)Codec.DELTA5, (Codec)Codec.BYTE1);
        specifiers = CodecEncoding.getSpecifier((Codec)runCodec, (Codec)Codec.DELTA5);
        Assertions.assertTrue((specifiers[0] > 116 ? 1 : 0) != 0);
        Assertions.assertTrue((specifiers[0] < 141 ? 1 : 0) != 0);
        bytes = new byte[specifiers.length - 1];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)specifiers[i + 1];
        }
        in = new ByteArrayInputStream(bytes);
        runCodec2 = (RunCodec)CodecEncoding.getCodec((int)specifiers[0], (InputStream)in, (Codec)Codec.DELTA5);
        Assertions.assertEquals((int)runCodec.getK(), (int)runCodec2.getK());
        Assertions.assertEquals((Object)runCodec.getACodec(), (Object)runCodec2.getACodec());
        Assertions.assertEquals((Object)runCodec.getBCodec(), (Object)runCodec2.getBCodec());
        runCodec = new RunCodec(64, (Codec)Codec.SIGNED5, (Codec)new RunCodec(25, (Codec)Codec.UDELTA5, (Codec)Codec.DELTA5));
        specifiers = CodecEncoding.getSpecifier((Codec)runCodec, null);
        Assertions.assertTrue((specifiers[0] > 116 ? 1 : 0) != 0);
        Assertions.assertTrue((specifiers[0] < 141 ? 1 : 0) != 0);
        bytes = new byte[specifiers.length - 1];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)specifiers[i + 1];
        }
        in = new ByteArrayInputStream(bytes);
        runCodec2 = (RunCodec)CodecEncoding.getCodec((int)specifiers[0], (InputStream)in, null);
        Assertions.assertEquals((int)runCodec.getK(), (int)runCodec2.getK());
        Assertions.assertEquals((Object)runCodec.getACodec(), (Object)runCodec2.getACodec());
        RunCodec bCodec = (RunCodec)runCodec.getBCodec();
        RunCodec bCodec2 = (RunCodec)runCodec2.getBCodec();
        Assertions.assertEquals((int)bCodec.getK(), (int)bCodec2.getK());
        Assertions.assertEquals((Object)bCodec.getACodec(), (Object)bCodec2.getACodec());
        Assertions.assertEquals((Object)bCodec.getBCodec(), (Object)bCodec2.getBCodec());
        runCodec = new RunCodec(64, (Codec)Codec.SIGNED5, (Codec)new RunCodec(25, (Codec)Codec.UDELTA5, (Codec)Codec.DELTA5));
        specifiers = CodecEncoding.getSpecifier((Codec)runCodec, (Codec)Codec.UDELTA5);
        Assertions.assertTrue((specifiers[0] > 116 ? 1 : 0) != 0);
        Assertions.assertTrue((specifiers[0] < 141 ? 1 : 0) != 0);
        bytes = new byte[specifiers.length - 1];
        for (int i3 = 0; i3 < bytes.length; ++i3) {
            bytes[i3] = (byte)specifiers[i3 + 1];
        }
        in = new ByteArrayInputStream(bytes);
        runCodec2 = (RunCodec)CodecEncoding.getCodec((int)specifiers[0], (InputStream)in, (Codec)Codec.UDELTA5);
        Assertions.assertEquals((int)runCodec.getK(), (int)runCodec2.getK());
        Assertions.assertEquals((Object)runCodec.getACodec(), (Object)runCodec2.getACodec());
        bCodec = (RunCodec)runCodec.getBCodec();
        bCodec2 = (RunCodec)runCodec2.getBCodec();
        Assertions.assertEquals((int)bCodec.getK(), (int)bCodec2.getK());
        Assertions.assertEquals((Object)bCodec.getACodec(), (Object)bCodec2.getACodec());
        Assertions.assertEquals((Object)bCodec.getBCodec(), (Object)bCodec2.getBCodec());
    }

    @ParameterizedTest
    @MethodSource(value={"specifier"})
    void testGetSpecifier(Codec c1) throws IOException, Pack200Exception {
        int[] specifiers = CodecEncoding.getSpecifier((Codec)c1, null);
        Assertions.assertEquals((int)3, (int)specifiers.length);
        Assertions.assertEquals((int)116, (int)specifiers[0]);
        byte[] bytes = new byte[]{(byte)specifiers[1], (byte)specifiers[2]};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((Object)c1, (Object)CodecEncoding.getCodec((int)116, (InputStream)in, null));
    }
}

