/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public final class TarLister {
    private static void log(TarArchiveEntry ae) {
        StringBuilder sb = new StringBuilder(Integer.toOctalString(ae.getMode())).append(" ");
        String name = ae.getUserName();
        if (name != null && !name.isEmpty()) {
            sb.append(name);
        } else {
            sb.append(ae.getLongUserId());
        }
        sb.append("/");
        name = ae.getGroupName();
        if (name != null && !name.isEmpty()) {
            sb.append(name);
        } else {
            sb.append(ae.getLongGroupId());
        }
        sb.append(" ");
        if (ae.isSparse()) {
            sb.append(ae.getRealSize());
        } else if (ae.isCharacterDevice() || ae.isBlockDevice()) {
            sb.append(ae.getDevMajor()).append(",").append(ae.getDevMinor());
        } else {
            sb.append(ae.getSize());
        }
        sb.append(" ").append(ae.getLastModifiedDate()).append(" ");
        sb.append(ae.getName());
        if (ae.isSymbolicLink() || ae.isLink()) {
            if (ae.isSymbolicLink()) {
                sb.append(" -> ");
            } else {
                sb.append(" link to ");
            }
            sb.append(ae.getLinkName());
        }
        if (ae.isSparse()) {
            sb.append(" (sparse)");
        }
        System.out.println(sb);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            TarLister.usage();
            return;
        }
        System.out.println("Analysing " + args[0]);
        File f = new File(args[0]);
        if (!f.isFile()) {
            System.err.println(f + " doesn't exist or is a directory");
        }
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));
             TarArchiveInputStream ais = args.length > 1 ? new TarArchiveInputStream((InputStream)fis, args[1]) : new TarArchiveInputStream((InputStream)fis);){
            TarArchiveEntry ae;
            System.out.println("Created " + ais);
            while ((ae = ais.getNextTarEntry()) != null) {
                TarLister.log(ae);
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [encoding]");
    }
}

