/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.utils.http;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.bsf.utils.http.HttpScriptContext;

public class HttpScriptServlet
extends GenericServlet {
    private static final long serialVersionUID = 1L;

    public HttpScriptContext getContext(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        return null;
    }

    public ScriptEngine getEngine(HttpServletRequest req) {
        return null;
    }

    public void releaseEngine(ScriptEngine eng) {
    }

    public void service(ServletRequest req, ServletResponse res) throws IllegalArgumentException, IOException, ServletException {
        int score;
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Method arguments should be HttpServletRequest and HttpServletResponse type");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpScriptContext context = this.getContext(request, response);
        if (context.disableScript()) {
            response.setStatus(403);
            return;
        }
        String requestMethod = request.getMethod();
        String[] allowedMethods = context.getMethods();
        for (score = 0; score < allowedMethods.length && !requestMethod.equalsIgnoreCase(allowedMethods[score]); ++score) {
        }
        if (score == allowedMethods.length) {
            response.setStatus(405);
            return;
        }
        ScriptEngine engine = this.getEngine(request);
        String[] languages = context.getAllowedLanguages();
        List<String> names = engine.getFactory().getNames();
        if (languages != null) {
            boolean found = false;
            for (int i = 0; i < languages.length; ++i) {
                for (int j = 0; j < names.size(); ++j) {
                    if (!languages[i].equals(names.get(i))) continue;
                    found = true;
                }
            }
            if (!found) {
                response.setStatus(403);
                return;
            }
        }
        try {
            Reader reader = context.getScriptSource();
            if (reader == null) {
                response.setStatus(404);
                return;
            }
            engine.put("javax.script.filename", request.getRequestURI());
            engine.put("Request", context.getRequest());
            engine.put("Response", context.getResponse());
            engine.put("Servlet", context.getServlet());
            engine.put("Context", context);
            Object retValue = engine.eval(reader, (ScriptContext)context);
            response.setContentType("text/html");
            if (retValue != null && context.displayResults()) {
                response.getWriter().write(retValue.toString());
            }
            response.getWriter().close();
        }
        catch (ScriptException se) {
            response.setStatus(500);
            throw new ServletException((Throwable)se);
        }
        finally {
            this.releaseEngine(engine);
            context.release();
        }
    }
}

