/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conf.FileConfiguration;
import org.apache.cayenne.project.ProjectDataSourceFactory;
import org.apache.cayenne.project.ProjectException;

public class ProjectConfiguration
extends FileConfiguration {
    public ProjectConfiguration(File projectFile) {
        super(projectFile);
        this.setIgnoringLoadFailures(true);
        this.locator.setSkipAbsolutePath(false);
        this.locator.setSkipClasspath(true);
        this.locator.setSkipCurrentDirectory(true);
        this.locator.setSkipHomeDirectory(true);
    }

    public boolean canInitialize() {
        return super.canInitialize() && this.getProjectFile().isFile();
    }

    protected void setProjectFile(File projectFile) {
        if (projectFile != null && projectFile.exists()) {
            super.setProjectFile(projectFile);
        } else {
            this.projectFile = projectFile;
            this.setDomainConfigurationName("cayenne.xml");
        }
    }

    public DataSourceFactory getDataSourceFactory(String userFactoryName) {
        File projectDir = this.getProjectDirectory();
        boolean canLoad = DriverDataSourceFactory.class.getName().equals(userFactoryName);
        ProjectDataSourceFactory factory = new ProjectDataSourceFactory(projectDir, canLoad);
        return factory;
    }

    public DataSourceFactory getDataSourceFactory() {
        try {
            return new ProjectDataSourceFactory(this.getProjectDirectory());
        }
        catch (Exception e) {
            throw new ProjectException("Error creating DataSourceFactory.", e);
        }
    }
}

