/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.query.ProcedureQuery;

public class ProcedureTranslator {
    private static NotInParam OUT_PARAM = new NotInParam("[OUT]");
    protected ProcedureQuery query;
    protected Connection connection;
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;
    protected List<ProcedureParameter> callParams;
    protected List<Object> values;

    public void setQuery(ProcedureQuery query) {
        this.query = query;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected String createSqlString() {
        Procedure procedure = this.getProcedure();
        StringBuilder buf = new StringBuilder();
        int totalParams = this.callParams.size();
        if (procedure.isReturningValue()) {
            --totalParams;
            buf.append("{? = call ");
        } else {
            buf.append("{call ");
        }
        buf.append(procedure.getFullyQualifiedName());
        if (totalParams > 0) {
            buf.append("(?");
            for (int i = 1; i < totalParams; ++i) {
                buf.append(", ?");
            }
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }

    public PreparedStatement createStatement() throws Exception {
        long t1 = System.currentTimeMillis();
        this.callParams = this.getProcedure().getCallParameters();
        this.values = new ArrayList<Object>(this.callParams.size());
        this.initValues();
        String sqlStr = this.createSqlString();
        if (QueryLogger.isLoggable()) {
            long time = System.currentTimeMillis() - t1;
            ArrayList<Object> loggableParameters = new ArrayList<Object>(this.values.size());
            for (Object val : this.values) {
                if (val instanceof NotInParam) {
                    val = val.toString();
                }
                loggableParameters.add(val);
            }
            QueryLogger.logQuery(sqlStr, null, loggableParameters, time);
        }
        CallableStatement stmt = this.connection.prepareCall(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }

    public Procedure getProcedure() {
        return this.entityResolver.lookupProcedure(this.query);
    }

    public ProcedureQuery getProcedureQuery() {
        return this.query;
    }

    protected void initStatement(CallableStatement stmt) throws Exception {
        if (this.values != null && this.values.size() > 0) {
            List<ProcedureParameter> params = this.getProcedure().getCallParameters();
            int len = this.values.size();
            for (int i = 0; i < len; ++i) {
                ProcedureParameter param = params.get(i);
                if (param.isOutParam()) {
                    this.setOutParam(stmt, param, i + 1);
                }
                if (!param.isInParameter()) continue;
                this.setInParam(stmt, param, this.values.get(i), i + 1);
            }
        }
    }

    protected void initValues() {
        Map<String, ?> queryValues = this.getProcedureQuery().getParameters();
        for (ProcedureParameter param : this.callParams) {
            if (param.getDirection() == 2) {
                this.values.add(OUT_PARAM);
                continue;
            }
            this.values.add(queryValues.get(param.getName()));
        }
    }

    protected void setInParam(CallableStatement stmt, ProcedureParameter param, Object val, int pos) throws Exception {
        int type = param.getType();
        this.adapter.bindParameter(stmt, val, pos, type, param.getPrecision());
    }

    protected void setOutParam(CallableStatement stmt, ProcedureParameter param, int pos) throws Exception {
        int precision = param.getPrecision();
        if (precision >= 0) {
            stmt.registerOutParameter(pos, param.getType(), precision);
        } else {
            stmt.registerOutParameter(pos, param.getType());
        }
    }

    static class NotInParam {
        protected String type;

        public NotInParam(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

