/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.util.List;
import org.apache.cayenne.access.select.EntitySelectColumn;
import org.apache.cayenne.access.select.MappedColumnBuilder;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHelper;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiscriminatorBuilder
extends MappedColumnBuilder {
    private EntityInheritanceTree node;

    DiscriminatorBuilder(ExtendedTypeMap extendedTypes, EntityInheritanceTree node) {
        super(extendedTypes);
        this.node = node;
    }

    List<EntitySelectColumn> buildColumns() {
        this.appendColumns(this.node);
        return this.columns;
    }

    private void appendColumns(EntityInheritanceTree node) {
        Expression qualifier;
        ObjEntity entity = node.getEntity();
        if (!entity.isAbstract() && (qualifier = entity.getDeclaredQualifier()) != null) {
            this.appendColumns(qualifier);
        }
        for (EntityInheritanceTree childNode : node.getChildren()) {
            this.appendColumns(childNode);
        }
    }

    private void appendColumns(Expression expression) {
        final ObjEntity entity = this.node.getEntity();
        final DbEntity dbEntity = entity.getDbEntity();
        expression.traverse(new TraversalHelper(){

            public void startNode(Expression node, Expression parentNode) {
                if (node.getType() == 27) {
                    DiscriminatorBuilder.this.append(dbEntity, node);
                } else if (node.getType() == 26) {
                    DiscriminatorBuilder.this.append(entity, node);
                }
            }
        });
    }
}

