/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataNodeSyncQualifierDescriptor {
    private List<DbAttribute> attributes;
    private List<Transformer> valueTransformers;
    private boolean usingOptimisticLocking;

    DataNodeSyncQualifierDescriptor() {
    }

    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    List<DbAttribute> getAttributes() {
        return this.attributes;
    }

    Map<String, Object> createQualifierSnapshot(ObjectDiff diff) {
        int len = this.attributes.size();
        HashMap<String, Object> map = new HashMap<String, Object>(len * 2);
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = this.attributes.get(i);
            if (map.containsKey(attribute.getName())) continue;
            Object value = this.valueTransformers.get(i).transform((Object)diff);
            map.put(attribute.getName(), value);
        }
        return map;
    }

    void reset(DbEntityClassDescriptor descriptor) {
        this.attributes = new ArrayList<DbAttribute>(3);
        this.valueTransformers = new ArrayList<Transformer>(3);
        boolean bl = this.usingOptimisticLocking = descriptor.getEntity().getLockType() == 1;
        if (descriptor.isMaster()) {
            for (final DbAttribute dbAttribute : descriptor.getDbEntity().getPrimaryKeys()) {
                this.attributes.add(dbAttribute);
                this.valueTransformers.add(new Transformer(){

                    public Object transform(Object input) {
                        ObjectId id = (ObjectId)((ObjectDiff)input).getNodeId();
                        return id.getIdSnapshot().get(dbAttribute.getName());
                    }
                });
            }
        } else {
            if (descriptor.getPathFromMaster().size() != 1) {
                throw new CayenneRuntimeException("Only single step dependent relationships are currently supported. Actual path length: " + descriptor.getPathFromMaster().size());
            }
            DbRelationship masterDependentDbRel = descriptor.getPathFromMaster().get(0);
            if (masterDependentDbRel != null) {
                for (final DbJoin dbAttrPair : masterDependentDbRel.getJoins()) {
                    DbAttribute dbAttribute = dbAttrPair.getTarget();
                    if (this.attributes.contains(dbAttribute)) continue;
                    this.attributes.add(dbAttribute);
                    this.valueTransformers.add(new Transformer(){

                        public Object transform(Object input) {
                            ObjectId id = (ObjectId)((ObjectDiff)input).getNodeId();
                            return id.getIdSnapshot().get(dbAttrPair.getSourceName());
                        }
                    });
                }
            }
        }
        if (this.usingOptimisticLocking) {
            for (final ObjAttribute objAttribute : descriptor.getEntity().getAttributes()) {
                DbAttribute dbAttribute;
                if (!objAttribute.isUsedForLocking() || this.attributes.contains(dbAttribute = (DbAttribute)objAttribute.getDbPathIterator().next())) continue;
                this.attributes.add(dbAttribute);
                this.valueTransformers.add(new Transformer(){

                    public Object transform(Object input) {
                        return ((ObjectDiff)input).getSnapshotValue(objAttribute.getName());
                    }
                });
            }
            for (final ObjRelationship objRelationship : descriptor.getEntity().getRelationships()) {
                if (!objRelationship.isUsedForLocking()) continue;
                DbRelationship dbRelationship = objRelationship.getDbRelationships().get(0);
                for (final DbJoin dbAttrPair : dbRelationship.getJoins()) {
                    DbAttribute dbAttribute = dbAttrPair.getSource();
                    int index = this.attributes.indexOf(dbAttribute);
                    if (index >= 0 && !dbAttribute.isForeignKey()) continue;
                    Transformer transformer = new Transformer(){

                        public Object transform(Object input) {
                            ObjectId targetId = ((ObjectDiff)input).getArcSnapshotValue(objRelationship.getName());
                            return targetId != null ? targetId.getIdSnapshot().get(dbAttrPair.getTargetName()) : null;
                        }
                    };
                    if (index < 0) {
                        this.attributes.add(dbAttribute);
                        this.valueTransformers.add(transformer);
                        continue;
                    }
                    this.valueTransformers.set(index, transformer);
                }
            }
        }
    }
}

